/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms.tracing;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class JmsTrace {
    private final String queue;
    private final Message jmsMessage;

    private JmsTrace(String queue, Message jmsMessage) {
        this.queue = queue;
        this.jmsMessage = jmsMessage;
    }

    public String getQueue() {
        return this.queue;
    }

    public Message getMessage() {
        return this.jmsMessage;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration propertyNames = null;
        try {
            propertyNames = this.jmsMessage.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                keys.add(propertyNames.nextElement().toString());
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return keys;
    }

    public String getProperty(String key) {
        try {
            return this.jmsMessage.getStringProperty(key);
        }
        catch (JMSException ignored) {
            return null;
        }
    }

    public void setProperty(String key, String value) {
        try {
            this.jmsMessage.setStringProperty(key, value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static class Builder {
        private String queue;
        private Message jmsMessage;

        public Builder withQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public Builder withMessage(Message message) {
            this.jmsMessage = message;
            return this;
        }

        public JmsTrace build() {
            return new JmsTrace(this.queue, this.jmsMessage);
        }
    }
}

