/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.smallrye.reactive.messaging.jms.tracing.JmsAttributesExtractor;
import io.smallrye.reactive.messaging.jms.tracing.JmsTrace;
import io.smallrye.reactive.messaging.jms.tracing.JmsTraceTextMapGetter;
import io.smallrye.reactive.messaging.jms.tracing.JmsTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class JmsOpenTelemetryInstrumenter {
    private final Instrumenter<JmsTrace, Void> instrumenter;

    private JmsOpenTelemetryInstrumenter(Instrumenter<JmsTrace, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static JmsOpenTelemetryInstrumenter createForSource(Instance<OpenTelemetry> openTelemetryInstance) {
        return JmsOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), true);
    }

    public static JmsOpenTelemetryInstrumenter createForSink(Instance<OpenTelemetry> openTelemetryInstance) {
        return JmsOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), false);
    }

    private static JmsOpenTelemetryInstrumenter create(OpenTelemetry openTelemetry, boolean source) {
        MessageOperation messageOperation = source ? MessageOperation.RECEIVE : MessageOperation.PUBLISH;
        JmsAttributesExtractor jmsAttributesExtractor = new JmsAttributesExtractor();
        MessagingAttributesGetter<JmsTrace, Void> messagingAttributesGetter = jmsAttributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation)).addAttributesExtractor((AttributesExtractor)jmsAttributesExtractor);
        Instrumenter instrumenter = source ? builder.buildConsumerInstrumenter((TextMapGetter)JmsTraceTextMapGetter.INSTANCE) : builder.buildProducerInstrumenter((TextMapSetter)JmsTraceTextMapSetter.INSTANCE);
        return new JmsOpenTelemetryInstrumenter((Instrumenter<JmsTrace, Void>)instrumenter);
    }

    public Message<?> traceIncoming(Message<?> message, JmsTrace jmsTrace) {
        return TracingUtils.traceIncoming(this.instrumenter, message, (Object)jmsTrace);
    }

    public void traceOutgoing(Message<?> message, JmsTrace jmsTrace) {
        TracingUtils.traceOutgoing(this.instrumenter, message, (Object)jmsTrace);
    }
}

