|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *client-id* | The client id | String | false |  |
| *connection-factory-name* | The name of the JMS connection factory  (`jakarta.jms.ConnectionFactory`) to be used. If not set, it uses any exposed JMS connection factory | String | false |  |
| *correlation-id* | The JMS Message correlation id | string | false |  |
| *delivery-delay* | The delivery delay | long | false |  |
| *delivery-mode* | The delivery mode. Either `persistent` or `non_persistent` | string | false |  |
| *destination* | The name of the JMS destination. If not set the name of the channel is used | String | false |  |
| *destination-type* | The type of destination. It can be either `queue` or `topic` | string | false | `queue` |
| *disable-message-id* | Omit the message id in the outbound JMS message | boolean | false |  |
| *disable-message-timestamp* | Omit the message timestamp in the outbound JMS message | boolean | false |  |
| *merge* | Whether the connector should allow multiple upstreams | boolean | false | `false` |
| *password* | The password to connect to to the JMS server | String | false |  |
| *priority* | The JMS Message priority | int | false |  |
| *reply-to* | The reply to destination if any | string | false |  |
| *reply-to-destination-type* | The type of destination for the response. It can be either `queue` or `topic` | string | false | `queue` |
| *retry* | Whether to retry on terminal stream errors. | boolean | false | `true` |
| *retry.initial-delay* | The initial delay for the retry. | string | false | `PT1S` |
| *retry.jitter* | How much the delay jitters as a multiplier between 0 and 1. The formula is current delay * jitter. For example, with a current delay of 2H, a jitter of 0.5 will result in an actual delay somewhere between 1H and 3H. | double | false | `0.5` |
| *retry.max-delay* | The maximum delay | string | false | `PT10S` |
| *retry.max-retries* | Maximum number of retries for terminal stream errors. | int | false | `3` |
| *reuse-jms-context* | Whether to reuse JMS contexts by creating child contexts from a parent context. When enabled, child contexts will be created using JMSContext.createContext() instead of ConnectionFactory.createContext() | boolean | false | `false` |
| *session-mode* | The session mode. Accepted values are AUTO_ACKNOWLEDGE, SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE | String | false | `AUTO_ACKNOWLEDGE` |
| *tracing-enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *ttl* | The JMS Message time-to-live | long | false |  |
| *username* | The username to connect to to the JMS server | String | false |  |
