/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import io.smallrye.reactive.messaging.jms.IncomingJmsMessageMetadata;
import io.smallrye.reactive.messaging.jms.i18n.JmsExceptions;
import io.smallrye.reactive.messaging.json.JsonMapping;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingJmsMessage<T>
implements org.eclipse.microprofile.reactive.messaging.Message<T> {
    private final Message delegate;
    private final Executor executor;
    private final Class<T> clazz;
    private final JsonMapping jsonMapping;
    private final IncomingJmsMessageMetadata jmsMetadata;
    private final Metadata metadata;

    IncomingJmsMessage(Message message, Executor executor, JsonMapping jsonMapping) {
        this.delegate = message;
        this.jsonMapping = jsonMapping;
        this.executor = executor;
        String cn = null;
        try {
            cn = message.getStringProperty("_classname");
            if (cn == null) {
                cn = message.getJMSType();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.clazz = cn != null ? this.load(cn) : null;
        }
        catch (ClassNotFoundException e) {
            throw JmsExceptions.ex.illegalStateUnableToLoadClass(e);
        }
        this.jmsMetadata = new IncomingJmsMessageMetadata(message);
        this.metadata = Metadata.of((Object[])new Object[]{this.jmsMetadata});
    }

    private Class<T> load(String cn) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return loader.loadClass(cn);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return IncomingJmsMessage.class.getClassLoader().loadClass(cn);
    }

    public T getPayload() {
        try {
            if (this.clazz != null) {
                return this.convert((String)this.delegate.getBody(String.class));
            }
            return (T)this.delegate.getBody(Object.class);
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    private T convert(String value) {
        if (this.clazz.equals(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (this.clazz.equals(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (this.clazz.equals(Double.class)) {
            return (T)Double.valueOf(value);
        }
        if (this.clazz.equals(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (this.clazz.equals(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (this.clazz.equals(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (this.clazz.equals(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (this.clazz.equals(String.class)) {
            return (T)value;
        }
        return (T)this.jsonMapping.fromJson(value, this.clazz);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.delegate.acknowledge();
            }
            catch (JMSException e) {
                throw new IllegalArgumentException("Unable to acknowledge message", e);
            }
        }, this.executor);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public <C> C unwrap(Class<C> unwrapType) {
        if (Message.class.equals(unwrapType)) {
            return (C)this.delegate;
        }
        if (IncomingJmsMessageMetadata.class.equals(unwrapType)) {
            return (C)this.jmsMetadata;
        }
        throw JmsExceptions.ex.illegalStateUnableToUnwrap(unwrapType);
    }
}

