/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.MessageHeaders;
import io.smallrye.reactive.messaging.kafka.SendingKafkaMessage;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;

public interface KafkaMessage<K, T>
extends Message<T> {
    public static <K, T> KafkaMessage<K, T> of(K key, T value) {
        return new SendingKafkaMessage<K, T>(null, key, value, null, null, new MessageHeaders(), null);
    }

    public static <K, T> KafkaMessage<K, T> withKeyAndValue(K key, T value) {
        return new SendingKafkaMessage<K, T>(null, key, value, null, null, new MessageHeaders(), null);
    }

    public static <K, T> KafkaMessage<K, T> of(String topic, K key, T value) {
        return new SendingKafkaMessage<K, T>(topic, key, value, null, null, new MessageHeaders(), null);
    }

    public static <K, T> KafkaMessage<K, T> of(String topic, K key, T value, Long timestamp, Integer partition) {
        return new SendingKafkaMessage<K, T>(topic, key, value, timestamp, partition, new MessageHeaders(), null);
    }

    default public KafkaMessage<K, T> withAck(Supplier<CompletionStage<Void>> ack) {
        return new SendingKafkaMessage<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), this.getHeaders(), ack);
    }

    public T getPayload();

    public K getKey();

    public String getTopic();

    public Integer getPartition();

    public Long getTimestamp();

    public MessageHeaders getHeaders();
}

