/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaMessage;
import io.smallrye.reactive.messaging.kafka.MessageHeaders;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumer;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class ReceivedKafkaMessage<K, T>
implements KafkaMessage<K, T> {
    private final KafkaConsumerRecord<K, T> record;
    private final KafkaConsumer<K, T> consumer;
    private final MessageHeaders headers;

    public ReceivedKafkaMessage(KafkaConsumer<K, T> consumer, KafkaConsumerRecord<K, T> record) {
        this.record = Objects.requireNonNull(record);
        this.consumer = Objects.requireNonNull(consumer);
        this.headers = new MessageHeaders(record.getDelegate().record().headers());
    }

    @Override
    public T getPayload() {
        return (T)this.record.value();
    }

    @Override
    public K getKey() {
        return (K)this.record.key();
    }

    @Override
    public String getTopic() {
        return this.record.topic();
    }

    @Override
    public Integer getPartition() {
        return this.record.partition();
    }

    @Override
    public Long getTimestamp() {
        return this.record.timestamp();
    }

    @Override
    public MessageHeaders getHeaders() {
        return this.headers;
    }

    public ConsumerRecord unwrap() {
        return this.record.getDelegate().record();
    }

    public CompletionStage<Void> ack() {
        this.consumer.commit();
        return CompletableFuture.completedFuture(null);
    }
}

