/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.kafka.companion.RecordsSubscriber;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public abstract class KafkaTask<T, SELF extends KafkaTask<T, SELF>>
implements Iterable<T>,
AutoCloseable {
    private final Multi<T> multi;
    private final RecordsSubscriber<T, ?> subscriber;

    public KafkaTask(Multi<T> multi) {
        this.multi = multi;
        this.subscriber = new RecordsSubscriber(Long.MAX_VALUE);
        this.multi.subscribe(this.subscriber);
    }

    public Multi<T> getMulti() {
        return this.multi;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getRecords().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.getRecords().spliterator();
    }

    protected SELF self() {
        return (SELF)this;
    }

    public long count() {
        return this.subscriber.count();
    }

    public T getFirstRecord() {
        return this.subscriber.getFirstRecord();
    }

    public T getLastRecord() {
        return this.subscriber.getLastRecord();
    }

    public List<T> getRecords() {
        return this.subscriber.getRecords();
    }

    public SELF awaitNextRecord() {
        this.subscriber.awaitNextRecord();
        return this.self();
    }

    public SELF awaitNextRecord(Duration duration) {
        this.subscriber.awaitNextRecord(duration);
        return this.self();
    }

    public SELF awaitNextRecords(int number) {
        this.subscriber.awaitNextRecords(number);
        return this.self();
    }

    public SELF awaitNextRecords(int number, Duration duration) {
        this.subscriber.awaitNextRecords(number, duration);
        return this.self();
    }

    public SELF awaitRecords(int number) {
        this.subscriber.awaitRecords(number);
        return this.self();
    }

    public SELF awaitRecords(int number, Duration duration) {
        this.subscriber.awaitRecords(number, duration);
        return this.self();
    }

    public SELF awaitCompletion() {
        this.subscriber.awaitCompletion();
        return this.self();
    }

    public SELF awaitCompletion(Duration duration) {
        this.subscriber.awaitCompletion(duration);
        return this.self();
    }

    public SELF awaitCompletion(BiConsumer<Throwable, Boolean> assertion) {
        this.subscriber.awaitCompletion(assertion);
        return this.self();
    }

    public SELF awaitCompletion(BiConsumer<Throwable, Boolean> assertion, Duration duration) {
        this.subscriber.awaitCompletion(assertion, duration);
        return this.self();
    }

    public SELF stop() {
        this.subscriber.cancel();
        return this.self();
    }

    @Override
    public void close() {
        this.stop();
    }

    public long firstOffset() {
        T firstRecord = this.subscriber.getFirstRecord();
        if (firstRecord == null) {
            return -1L;
        }
        return this.offset(firstRecord);
    }

    public long lastOffset() {
        T lastRecord = this.subscriber.getLastRecord();
        if (lastRecord == null) {
            return -1L;
        }
        return this.offset(lastRecord);
    }

    public Map<TopicPartition, List<T>> byTopicPartition() {
        return this.subscriber.getRecords().stream().collect(Collectors.groupingBy(this::topicPartition));
    }

    protected abstract long offset(T var1);

    protected abstract TopicPartition topicPartition(T var1);
}

