/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;

public class TopicsCompanion {
    private final AdminClient adminClient;
    private final Duration kafkaApiTimeout;

    public TopicsCompanion(AdminClient adminClient, Duration kafkaApiTimeout) {
        this.adminClient = adminClient;
        this.kafkaApiTimeout = kafkaApiTimeout;
    }

    public void create(Collection<NewTopic> newTopics) {
        KafkaCompanion.toUni(this.adminClient.createTopics(newTopics).all()).await().atMost(this.kafkaApiTimeout);
    }

    public void create(Map<String, Integer> topicPartitions) {
        this.create(topicPartitions.entrySet().stream().map(e -> new NewTopic((String)e.getKey(), ((Integer)e.getValue()).intValue(), 1)).collect(Collectors.toList()));
    }

    public void create(String topic, int partition) {
        this.create(Collections.singletonList(new NewTopic(topic, partition, 1)));
    }

    public String createAndWait(String topic, int partition) {
        this.create(topic, partition);
        this.waitForTopic(topic).await().atMost(this.kafkaApiTimeout);
        return topic;
    }

    public TopicDescription createAndWait(String topic, int partition, Duration timeout) {
        this.create(topic, partition);
        return (TopicDescription)this.waitForTopic(topic).await().atMost(timeout);
    }

    public Uni<TopicDescription> waitForTopic(String topic) {
        AtomicInteger retries = new AtomicInteger(0);
        return Uni.createFrom().item(this::describeAll).repeat().withDelay(Duration.ofMillis(1000L)).until(topics -> {
            if (retries.incrementAndGet() >= 10) {
                throw new IllegalStateException("Max number of attempts reached, the topic " + topic + " was not created after 10 attempts");
            }
            return !this.checkIfTheTopicIsCreated(topic, (Map<String, TopicDescription>)topics);
        }).select().where(Objects::nonNull).toUni().map(topics -> (TopicDescription)topics.get(topic));
    }

    boolean checkIfTheTopicIsCreated(String topic, Map<String, TopicDescription> description) {
        if (description == null) {
            return false;
        }
        TopicDescription td = description.get(topic);
        if (td == null) {
            return false;
        }
        List partitions = td.partitions();
        for (TopicPartitionInfo partition : partitions) {
            if (partition.leader() != null && partition.leader().id() >= 0) continue;
            return false;
        }
        return true;
    }

    public Set<String> list() {
        return (Set)KafkaCompanion.toUni(this.adminClient.listTopics().names()).await().atMost(this.kafkaApiTimeout);
    }

    public Map<String, TopicDescription> describeAll() {
        return (Map)KafkaCompanion.toUni(this.adminClient.listTopics().names()).onItem().transformToUni(topics -> KafkaCompanion.toUni(this.adminClient.describeTopics((Collection)topics).allTopicNames())).await().atMost(this.kafkaApiTimeout);
    }

    public Map<String, TopicDescription> describe(String ... topics) {
        if (topics.length == 0) {
            return this.describeAll();
        }
        return (Map)KafkaCompanion.toUni(this.adminClient.describeTopics(Arrays.asList(topics)).allTopicNames()).await().atMost(this.kafkaApiTimeout);
    }

    public void delete(Collection<String> topics) {
        KafkaCompanion.toUni(this.adminClient.deleteTopics(topics).all()).await().atMost(this.kafkaApiTimeout);
    }

    public void delete(String ... topics) {
        this.delete(Arrays.asList(topics));
    }
}

