/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class ConsumerGroupsCompanion {
    final AdminClient adminClient;
    final Duration kafkaApiTimeout;

    public ConsumerGroupsCompanion(AdminClient adminClient, Duration kafkaApiTimeout) {
        this.adminClient = adminClient;
        this.kafkaApiTimeout = kafkaApiTimeout;
    }

    public Collection<ConsumerGroupListing> list() {
        return (Collection)KafkaCompanion.toUni(this.adminClient.listConsumerGroups().all()).await().atMost(this.kafkaApiTimeout);
    }

    public Map<String, ConsumerGroupDescription> describe(String ... groupId) {
        return (Map)KafkaCompanion.toUni(this.adminClient.describeConsumerGroups(Arrays.asList(groupId)).all()).await().atMost(this.kafkaApiTimeout);
    }

    public ConsumerGroupDescription describe(String groupId) {
        return (ConsumerGroupDescription)KafkaCompanion.toUni(this.adminClient.describeConsumerGroups(Collections.singleton(groupId)).all()).onItem().transform(result -> (ConsumerGroupDescription)result.get(groupId)).await().atMost(this.kafkaApiTimeout);
    }

    public void delete(String ... groupId) {
        KafkaCompanion.toUni(this.adminClient.deleteConsumerGroups(Arrays.asList(groupId)).all()).await().atMost(this.kafkaApiTimeout);
    }

    public void removeMembers(String groupId, String ... groupInstanceIds) {
        KafkaCompanion.toUni(this.adminClient.removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions((Collection)Arrays.stream(groupInstanceIds).map(MemberToRemove::new).collect(Collectors.toList()))).all()).await().atMost(this.kafkaApiTimeout);
    }

    private Uni<Map<TopicPartition, OffsetAndMetadata>> consumerGroupUni(String groupId, List<TopicPartition> topicPartitions) {
        return KafkaCompanion.toUni(this.adminClient.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions().topicPartitions(topicPartitions)).partitionsToOffsetAndMetadata());
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets(String groupId, List<TopicPartition> topicPartitions) {
        return (Map)this.consumerGroupUni(groupId, topicPartitions).await().atMost(this.kafkaApiTimeout);
    }

    public OffsetAndMetadata offsets(String groupId, TopicPartition topicPartitions) {
        return (OffsetAndMetadata)this.consumerGroupUni(groupId, Collections.singletonList(topicPartitions)).onItem().transform(m -> (OffsetAndMetadata)m.get(topicPartitions)).await().atMost(this.kafkaApiTimeout);
    }

    public Map<String, Map<TopicPartition, OffsetAndMetadata>> offsets(List<TopicPartition> topicPartitions) {
        return (Map)KafkaCompanion.toUni(this.adminClient.listConsumerGroups().all()).onItem().transformToMulti(groups -> Multi.createFrom().iterable((Iterable)groups)).onItem().transformToUniAndMerge(group -> this.consumerGroupUni(group.groupId(), topicPartitions).map(m -> Tuple2.of((Object)group.groupId(), (Object)m))).collect().asMap(Tuple2::getItem1, Tuple2::getItem2).await().atMost(this.kafkaApiTimeout);
    }

    public void alterOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> topicPartitionOffsets) {
        KafkaCompanion.toUni(this.adminClient.alterConsumerGroupOffsets(groupId, topicPartitionOffsets).all()).await().atMost(this.kafkaApiTimeout);
    }

    public void resetOffsets(String groupId, TopicPartition partition) {
        HashMap<TopicPartition, OffsetAndMetadata> offsetMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsetMap.put(partition, new OffsetAndMetadata(0L));
        this.alterOffsets(groupId, offsetMap);
    }

    public void deleteOffsets(String groupId, List<TopicPartition> topicPartitions) {
        KafkaCompanion.toUni(this.adminClient.deleteConsumerGroupOffsets(groupId, new HashSet<TopicPartition>(topicPartitions)).all()).await().atMost(this.kafkaApiTimeout);
    }
}

