/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion.test;

import eu.rekawek.toxiproxy.model.ToxicDirection;
import eu.rekawek.toxiproxy.model.ToxicList;
import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import io.smallrye.reactive.messaging.kafka.companion.test.KafkaBrokerExtension;
import io.smallrye.reactive.messaging.kafka.companion.test.KafkaProxy;
import io.smallrye.reactive.messaging.kafka.companion.test.KafkaToxiproxyExtension;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={KafkaToxiproxyExtension.class})
public class KafkaCompanionProxyTestBase {
    public static KafkaProxy proxy;
    private static boolean connectionCut;
    public static KafkaCompanion companion;
    public String topic;

    @BeforeAll
    static void initCompanion(@KafkaBrokerExtension.KafkaBootstrapServers String bootstrapServers, KafkaProxy kafkaProxy) {
        companion = new KafkaCompanion(bootstrapServers);
        proxy = kafkaProxy;
    }

    @BeforeEach
    public void initTopic(TestInfo testInfo) {
        String cn = testInfo.getTestClass().map(Class::getSimpleName).orElse(UUID.randomUUID().toString());
        String mn = testInfo.getTestMethod().map(Method::getName).orElse(UUID.randomUUID().toString());
        this.topic = cn + "-" + mn + "-" + UUID.randomUUID().getMostSignificantBits();
    }

    @AfterAll
    static void closeCompanion() {
        companion.close();
    }

    public ToxicList toxics() {
        return KafkaCompanionProxyTestBase.proxy.toxi.toxics();
    }

    public void enableProxy() {
        try {
            KafkaCompanionProxyTestBase.proxy.toxi.enable();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not control proxy", e);
        }
    }

    public void disableProxy() {
        try {
            KafkaCompanionProxyTestBase.proxy.toxi.disable();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not control proxy", e);
        }
    }

    public boolean connectionCut(boolean cut) {
        try {
            if (cut && !connectionCut) {
                this.toxics().bandwidth("CUT_CONNECTION_DOWNSTREAM", ToxicDirection.DOWNSTREAM, 0L);
                this.toxics().bandwidth("CUT_CONNECTION_UPSTREAM", ToxicDirection.UPSTREAM, 0L);
                connectionCut = true;
                return true;
            }
            if (!cut && connectionCut) {
                this.toxics().get("CUT_CONNECTION_DOWNSTREAM").remove();
                this.toxics().get("CUT_CONNECTION_UPSTREAM").remove();
                connectionCut = false;
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not control proxy", e);
        }
        return false;
    }

    static {
        connectionCut = false;
    }
}

