/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion.test;

import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import io.smallrye.reactive.messaging.kafka.companion.test.KafkaProxy;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.utility.DockerImageName;

public class ProxiedStrimziKafkaContainer
extends StrimziKafkaContainer {
    public static final Logger LOGGER = Logger.getLogger((String)ProxiedStrimziKafkaContainer.class.getName());
    public static final int KAFKA_PORT = 9092;
    public static final String TOXIPROXY_NETWORK_ALIAS = "toxiproxy";
    public static final String KAFKA_NETWORK_ALIAS = "kafka";
    public static final String TOXIPROXY_IMAGE_NAME_PROPERTY_KEY = "toxiproxy.image.name";
    public static final String DEFAULT_TOXIPROXY_IMAGE_NAME = "ghcr.io/shopify/toxiproxy:2.4.0";
    private final ToxiproxyContainer toxiproxy = (ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)System.getProperty("toxiproxy.image.name", "ghcr.io/shopify/toxiproxy:2.4.0")).asCompatibleSubstituteFor("shopify/toxiproxy")).withNetworkAliases(new String[]{"toxiproxy"});
    private KafkaProxy kafkaProxy;

    public ProxiedStrimziKafkaContainer() {
    }

    public ProxiedStrimziKafkaContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected void doStart() {
        this.withNetworkAliases(new String[]{KAFKA_NETWORK_ALIAS});
        ((ToxiproxyContainer)this.toxiproxy.withNetwork(this.getNetwork())).start();
        Awaitility.await().until(() -> ((ToxiproxyContainer)this.toxiproxy).isRunning());
        List exposedPorts = this.toxiproxy.getExposedPorts();
        int toxiPort = (Integer)exposedPorts.get(exposedPorts.size() - 1);
        this.kafkaProxy = this.createContainerProxy(this.toxiproxy, toxiPort);
        LOGGER.infof("Kafka proxy started : %s", (Object)this.getBootstrapServers());
        super.doStart();
    }

    private KafkaProxy createContainerProxy(ToxiproxyContainer toxiproxy, int toxiPort) {
        try {
            ToxiproxyClient client = new ToxiproxyClient(toxiproxy.getHost(), toxiproxy.getControlPort());
            String upstream = "kafka:9092";
            Proxy toxi = client.createProxy(upstream, "0.0.0.0:" + toxiPort, upstream);
            return new KafkaProxy(toxi, toxiproxy.getHost(), toxiproxy.getMappedPort(toxiPort), toxiPort);
        }
        catch (IOException e) {
            throw new RuntimeException("Proxy could not be created", e);
        }
    }

    public KafkaProxy getKafkaProxy() {
        return this.kafkaProxy;
    }

    public void stop() {
        LOGGER.info((Object)"Stopping Kafka proxy");
        this.toxiproxy.stop();
        super.stop();
    }

    public String getBootstrapServers() {
        return this.kafkaProxy.getProxyBootstrapServers();
    }
}

