/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.JsonHelper;
import io.smallrye.reactive.messaging.kafka.KafkaMessage;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSink.class);
    private final KafkaWriteStream stream;
    private final int partition;
    private final String key;
    private final String topic;
    private final SubscriberBuilder<? extends Message, Void> subscriber;

    KafkaSink(io.vertx.reactivex.core.Vertx vertx, Config config) {
        JsonObject entries = JsonHelper.asJsonObject(config);
        if (entries.containsKey("acks")) {
            entries.put("acks", entries.getValue("acks").toString());
        }
        this.stream = KafkaWriteStream.create((Vertx)vertx.getDelegate(), (Map)entries.getMap());
        this.stream.exceptionHandler(t -> LOGGER.error("Unable to write to Kafka", t));
        this.partition = config.getOptionalValue("partition", Integer.class).orElse(-1);
        this.key = config.getOptionalValue("key", String.class).orElse(null);
        this.topic = config.getOptionalValue("topic", String.class).orElse(null);
        if (this.topic == null) {
            LOGGER.warn("No default topic configured, only sending messages with an explicit topic set");
        }
        this.subscriber = ReactiveStreams.builder().flatMapCompletionStage(message -> {
            try {
                ProducerRecord record;
                if (message instanceof KafkaMessage) {
                    KafkaMessage km = (KafkaMessage)message;
                    if (this.topic == null && km.getTopic() == null) {
                        LOGGER.error("Ignoring message - no topic set");
                        return CompletableFuture.completedFuture(null);
                    }
                    Integer actualPartition = null;
                    if (this.partition != -1) {
                        actualPartition = this.partition;
                    }
                    if (km.getPartition() != null) {
                        actualPartition = km.getPartition();
                    }
                    record = new ProducerRecord(km.getTopic() == null ? this.topic : km.getTopic(), actualPartition, km.getTimestamp(), (Object)(km.getKey() == null ? this.key : km.getKey()), km.getPayload(), km.getHeaders().unwrap());
                    LOGGER.info("Sending message {} to Kafka topic '{}'", message, (Object)record.topic());
                } else {
                    if (this.topic == null) {
                        LOGGER.error("Ignoring message - no topic set");
                        return CompletableFuture.completedFuture(null);
                    }
                    record = this.partition == -1 ? new ProducerRecord(this.topic, null, null, (Object)this.key, message.getPayload()) : new ProducerRecord(this.topic, Integer.valueOf(this.partition), null, (Object)this.key, message.getPayload());
                }
                CompletableFuture future = new CompletableFuture();
                Handler handler = ar -> {
                    if (ar.succeeded()) {
                        LOGGER.info("Message {} sent successfully to Kafka topic {}", message, (Object)record.topic());
                        future.complete(ar.result());
                    } else {
                        LOGGER.error("Message {} was not sent to Kafka topic {}", new Object[]{message, record.topic(), ar.cause()});
                        future.completeExceptionally(ar.cause());
                    }
                };
                LOGGER.debug("Using stream {} to write the record {}", (Object)this.stream, (Object)record);
                this.stream.write(record, handler);
                return future;
            }
            catch (RuntimeException e) {
                LOGGER.error("Unable to send a record to Kafka ", (Throwable)e);
                return CompletableFuture.completedFuture(message);
            }
        }).ignore();
    }

    SubscriberBuilder<? extends Message, Void> getSink() {
        return this.subscriber;
    }

    void close() {
        this.stream.close();
    }
}

