/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.kafka.JsonHelper;
import io.smallrye.reactive.messaging.kafka.KafkaMessage;
import io.smallrye.reactive.messaging.kafka.ReceivedKafkaMessage;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumer;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSource.class);
    private final PublisherBuilder<KafkaMessage> source;
    private final KafkaConsumer<K, V> consumer;

    KafkaSource(Vertx vertx, Config config) {
        HashMap<String, String> kafkaConfiguration = new HashMap<String, String>();
        String group = config.getOptionalValue("group.id", String.class).orElseGet(() -> {
            String s = UUID.randomUUID().toString();
            LOGGER.warn("No `group.id` set in the configuration, generate a random id: {}", (Object)s);
            return s;
        });
        JsonHelper.asJsonObject(config).forEach(e -> kafkaConfiguration.put((String)e.getKey(), e.getValue().toString()));
        kafkaConfiguration.put("group.id", group);
        this.consumer = KafkaConsumer.create((Vertx)vertx, kafkaConfiguration);
        String topic = config.getOptionalValue("topic", String.class).orElseGet(() -> (String)config.getValue("name", String.class));
        Objects.requireNonNull(topic, "The topic must be set, or the name must be set");
        Flowable flowable = this.consumer.toFlowable();
        if (config.getOptionalValue("retry", Boolean.class).orElse(true).booleanValue()) {
            Integer max = config.getOptionalValue("retry-attempts", Integer.class).orElse(5);
            flowable = flowable.retryWhen(attempts -> attempts.zipWith((Publisher)Flowable.range((int)1, (int)max), (n, i) -> i).flatMap(i -> Flowable.timer((long)i.intValue(), (TimeUnit)TimeUnit.SECONDS)));
        }
        if (config.getOptionalValue("broadcast", Boolean.class).orElse(false).booleanValue()) {
            flowable = flowable.publish().autoConnect();
        }
        this.source = ReactiveStreams.fromPublisher((Publisher)flowable.doOnSubscribe(s -> this.consumer.subscribe(topic))).map(rec -> new ReceivedKafkaMessage<K, V>(this.consumer, rec));
    }

    PublisherBuilder<KafkaMessage> getSource() {
        return this.source;
    }

    void close() {
        this.consumer.close();
    }
}

