/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaSink;
import io.smallrye.reactive.messaging.kafka.KafkaSource;
import io.vertx.reactivex.core.Vertx;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@ApplicationScoped
@Connector(value="smallrye-kafka")
public class KafkaConnector
implements IncomingConnectorFactory,
OutgoingConnectorFactory {
    static final String CONNECTOR_NAME = "smallrye-kafka";
    @Inject
    private Instance<Vertx> instanceOfVertx;
    @Inject
    @ConfigProperty(name="kafka.bootstrap.servers", defaultValue="localhost:9092")
    private String servers;
    private List<KafkaSource> sources = new CopyOnWriteArrayList<KafkaSource>();
    private List<KafkaSink> sinks = new CopyOnWriteArrayList<KafkaSink>();
    private boolean internalVertxInstance = false;
    private Vertx vertx;

    public void terminate(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.sources.forEach(KafkaSource::closeQuietly);
        this.sinks.forEach(KafkaSink::closeQuietly);
        if (this.internalVertxInstance) {
            this.vertx.close();
        }
    }

    @PostConstruct
    void init() {
        if (this.instanceOfVertx.isUnsatisfied()) {
            this.internalVertxInstance = true;
            this.vertx = Vertx.vertx();
        } else {
            this.vertx = (Vertx)this.instanceOfVertx.get();
        }
    }

    public PublisherBuilder<? extends Message<?>> getPublisherBuilder(Config config) {
        String s = this.servers;
        KafkaSource source = new KafkaSource(this.vertx, config, s);
        this.sources.add(source);
        return source.getSource();
    }

    public SubscriberBuilder<? extends Message<?>, Void> getSubscriberBuilder(Config config) {
        String s = this.servers;
        KafkaSink sink = new KafkaSink(this.vertx, config, s);
        this.sinks.add(sink);
        return sink.getSink();
    }
}

