/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.kafka.client.consumer.KafkaConsumer;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSource.class);
    private final PublisherBuilder<? extends Message<?>> source;
    private final KafkaConsumer<K, V> consumer;

    public KafkaSource(Vertx vertx, Config config, String servers) {
        HashMap<String, String> kafkaConfiguration = new HashMap<String, String>();
        String group = config.getOptionalValue("group.id", String.class).orElseGet(() -> {
            String s = UUID.randomUUID().toString();
            LOGGER.warn("No `group.id` set in the configuration, generate a random id: {}", (Object)s);
            return s;
        });
        JsonHelper.asJsonObject(config).forEach(e -> kafkaConfiguration.put((String)e.getKey(), e.getValue().toString()));
        kafkaConfiguration.put("group.id", group);
        if (!kafkaConfiguration.containsKey("bootstrap.servers")) {
            LOGGER.info("Setting {} to {}", (Object)"bootstrap.servers", (Object)servers);
            kafkaConfiguration.put("bootstrap.servers", servers);
        }
        if (!kafkaConfiguration.containsKey("key.deserializer")) {
            LOGGER.info("Key deserializer omitted, using String as default");
            kafkaConfiguration.put("key.deserializer", StringDeserializer.class.getName());
        }
        kafkaConfiguration.remove("channel-name");
        kafkaConfiguration.remove("topic");
        kafkaConfiguration.remove("connector");
        kafkaConfiguration.remove("retry");
        kafkaConfiguration.remove("retry-attempts");
        kafkaConfiguration.remove("broadcast");
        this.consumer = KafkaConsumer.create((Vertx)vertx, kafkaConfiguration);
        String topic = this.getTopicOrFail(config);
        Objects.requireNonNull(topic, "The topic must be set, or the name must be set");
        Flowable flowable = this.consumer.toFlowable().doOnError(t -> LOGGER.error("Unable to read a record from Kafka topic '{}'", (Object)topic, t));
        if (config.getOptionalValue("retry", Boolean.class).orElse(true).booleanValue()) {
            Integer max = config.getOptionalValue("retry-attempts", Integer.class).orElse(5);
            flowable = flowable.retryWhen(attempts -> attempts.zipWith((Publisher)Flowable.range((int)1, (int)max), (n, i) -> i).flatMap(i -> Flowable.timer((long)i.intValue(), (TimeUnit)TimeUnit.SECONDS)));
        }
        if (config.getOptionalValue("broadcast", Boolean.class).orElse(false).booleanValue()) {
            flowable = flowable.publish().autoConnect();
        }
        this.source = ReactiveStreams.fromPublisher((Publisher)flowable.doOnSubscribe(s -> this.consumer.subscribe(topic))).map(rec -> new IncomingKafkaRecord<K, V>(this.consumer, rec));
    }

    public PublisherBuilder<? extends Message<?>> getSource() {
        return this.source;
    }

    public void closeQuietly() {
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.consumer.close(ar -> {
                if (ar.failed()) {
                    LOGGER.debug("An exception has been caught while closing the Kafka consumer", ar.cause());
                }
                latch.countDown();
            });
        }
        catch (Throwable e) {
            LOGGER.debug("An exception has been caught while closing the Kafka consumer", e);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private String getTopicOrFail(Config config) {
        return config.getOptionalValue("topic", String.class).orElseGet(() -> (String)config.getOptionalValue("channel-name", String.class).orElseThrow(() -> new IllegalArgumentException("Topic attribute must be set")));
    }
}

