/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.core.json.JsonObject;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable propertyNames = config.getPropertyNames();
        for (String key : propertyNames) {
            try {
                int i = (Integer)config.getValue(key, Integer.class);
                json.put(key, Integer.valueOf(i));
            }
            catch (ClassCastException | IllegalArgumentException i) {
                try {
                    double d = (Double)config.getValue(key, Double.class);
                    json.put(key, Double.valueOf(d));
                }
                catch (ClassCastException | IllegalArgumentException d) {
                    try {
                        String value = (String)config.getValue(key, String.class);
                        if (value.trim().equalsIgnoreCase("false")) {
                            json.put(key, Boolean.valueOf(false));
                            continue;
                        }
                        if (value.trim().equalsIgnoreCase("true")) {
                            json.put(key, Boolean.valueOf(true));
                            continue;
                        }
                        json.put(key, (String)config.getValue(key, String.class));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
        return json;
    }
}

