/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.client.consumer.KafkaConsumer;
import java.time.Duration;
import java.util.HashMap;
import java.util.UUID;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSource.class);
    private final PublisherBuilder<? extends Message<?>> source;
    private final KafkaConsumer<K, V> consumer;

    public KafkaSource(Vertx vertx, KafkaConnectorIncomingConfiguration config) {
        HashMap<String, String> kafkaConfiguration = new HashMap<String, String>();
        String group = config.getGroupId().orElseGet(() -> {
            String s = UUID.randomUUID().toString();
            LOGGER.warn("No `group.id` set in the configuration, generate a random id: {}", (Object)s);
            return s;
        });
        JsonHelper.asJsonObject(config.config()).forEach(e -> kafkaConfiguration.put((String)e.getKey(), e.getValue().toString()));
        kafkaConfiguration.put("group.id", group);
        String servers = config.getBootstrapServers();
        if (!kafkaConfiguration.containsKey("bootstrap.servers")) {
            LOGGER.info("Setting {} to {}", (Object)"bootstrap.servers", (Object)servers);
            kafkaConfiguration.put("bootstrap.servers", servers);
        }
        if (!kafkaConfiguration.containsKey("key.deserializer")) {
            LOGGER.info("Key deserializer omitted, using String as default");
            kafkaConfiguration.put("key.deserializer", config.getKeyDeserializer());
        }
        kafkaConfiguration.remove("channel-name");
        kafkaConfiguration.remove("topic");
        kafkaConfiguration.remove("connector");
        kafkaConfiguration.remove("retry");
        kafkaConfiguration.remove("retry-attempts");
        kafkaConfiguration.remove("broadcast");
        this.consumer = KafkaConsumer.create((Vertx)vertx, kafkaConfiguration);
        String topic = config.getTopic().orElseGet(config::getChannel);
        Multi multi = this.consumer.toMulti().onFailure().invoke(t -> LOGGER.error("Unable to read a record from Kafka topic '{}'", (Object)topic, t));
        if (config.getRetry().booleanValue()) {
            int max = config.getRetryAttempts();
            int maxWait = config.getRetryMaxWait();
            if (max == -1) {
                multi.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost(Long.MAX_VALUE);
            } else {
                multi = multi.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost((long)max);
            }
        }
        if (config.getBroadcast().booleanValue()) {
            multi = multi.broadcast().toAllSubscribers();
        }
        this.source = ReactiveStreams.fromPublisher((Publisher)multi.on().subscribed(s -> this.consumer.subscribeAndAwait(topic))).map(rec -> new IncomingKafkaRecord<K, V>(this.consumer, rec));
    }

    public PublisherBuilder<? extends Message<?>> getSource() {
        return this.source;
    }

    public void closeQuietly() {
        try {
            this.consumer.closeAndAwait();
        }
        catch (Throwable e) {
            LOGGER.debug("An exception has been caught while closing the Kafka consumer", e);
        }
    }
}

