/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class OutgoingKafkaRecord<K, T>
implements KafkaRecord<K, T> {
    private final T value;
    private final Supplier<CompletionStage<Void>> ack;
    private final Metadata metadata;
    private final OutgoingKafkaRecordMetadata<K> kafkaMetadata;

    public OutgoingKafkaRecord(String topic, K key, T value, Instant timestamp, int partition, Headers headers, Supplier<CompletionStage<Void>> ack) {
        this.kafkaMetadata = new OutgoingKafkaRecordMetadata<K>(topic, key, partition, timestamp, headers);
        this.metadata = Metadata.of((Object[])new Object[]{this.kafkaMetadata});
        this.value = value;
        this.ack = ack;
    }

    public static <K, T> OutgoingKafkaRecord<K, T> from(Message<T> message) {
        OutgoingKafkaRecordMetadata kafkaMetadata = (OutgoingKafkaRecordMetadata)message.getMetadata(OutgoingKafkaRecordMetadata.class).orElseThrow(() -> KafkaExceptions.ex.illegalArgumentNoMetadata(OutgoingKafkaRecordMetadata.class));
        return new OutgoingKafkaRecord(kafkaMetadata.getTopic(), kafkaMetadata.getKey(), message.getPayload(), kafkaMetadata.getTimestamp(), kafkaMetadata.getPartition(), kafkaMetadata.getHeaders(), message.getAck());
    }

    public CompletionStage<Void> ack() {
        if (this.ack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.ack.get();
    }

    public T getPayload() {
        return this.value;
    }

    @Override
    public K getKey() {
        return this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this.ack;
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final byte[] content) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content;
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck());
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final String content) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content.getBytes();
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck());
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final String content, final Charset enc) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content.getBytes(enc);
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck());
    }

    public <P> OutgoingKafkaRecord<K, P> withPayload(P payload) {
        return OutgoingKafkaRecord.from(Message.of(payload, (Metadata)this.getMetadata(), this.getAck()));
    }

    public OutgoingKafkaRecord<K, T> withMetadata(Iterable<Object> metadata) {
        Metadata newMetadata = this.getMetadata().with(metadata);
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)newMetadata, this.getAck()));
    }

    public OutgoingKafkaRecord<K, T> withMetadata(Metadata metadata) {
        Metadata newMetadata = this.getMetadata().with((Object)metadata);
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)newMetadata, this.getAck()));
    }

    public OutgoingKafkaRecord<K, T> withAck(Supplier<CompletionStage<Void>> supplier) {
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)this.getMetadata(), supplier));
    }
}

