/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class KafkaConnectorOutgoingConfiguration
extends KafkaConnectorCommonConfiguration {
    public KafkaConnectorOutgoingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public String getKeySerializer() {
        return this.config.getOptionalValue("key.serializer", String.class).orElse("org.apache.kafka.common.serialization.StringSerializer");
    }

    public String getValueSerializer() {
        return (String)this.config.getOptionalValue("value.serializer", String.class).orElseThrow(() -> new IllegalArgumentException("The attribute `value.serializer` on connector 'smallrye-kafka' (channel: " + this.getChannel() + ") must be set"));
    }

    public String getAcks() {
        return this.config.getOptionalValue("acks", String.class).orElse("1");
    }

    public Long getBufferMemory() {
        return this.config.getOptionalValue("buffer.memory", Long.class).orElse(Long.valueOf("33554432"));
    }

    public Long getRetries() {
        return this.config.getOptionalValue("retries", Long.class).orElse(Long.valueOf("2147483647"));
    }

    public Optional<String> getKey() {
        return this.config.getOptionalValue("key", String.class);
    }

    public Integer getPartition() {
        return this.config.getOptionalValue("partition", Integer.class).orElse(Integer.valueOf("-1"));
    }

    public Boolean getWaitForWriteCompletion() {
        return this.config.getOptionalValue("waitForWriteCompletion", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Integer getMaxInflightMessages() {
        return this.config.getOptionalValue("max-inflight-messages", Integer.class).orElse(Integer.valueOf("5"));
    }

    @Override
    public void validate() {
        super.validate();
        this.getValueSerializer();
    }
}

