/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord;
import java.time.Instant;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Headers;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingKafkaRecord<K, T>
implements KafkaRecord<K, T> {
    private final Metadata metadata;
    private final IncomingKafkaRecordMetadata<K, T> kafkaMetadata;
    private final KafkaCommitHandler commitHandler;
    private final KafkaFailureHandler onNack;

    public IncomingKafkaRecord(KafkaConsumerRecord<K, T> record, KafkaCommitHandler commitHandler, KafkaFailureHandler onNack) {
        this.kafkaMetadata = new IncomingKafkaRecordMetadata<K, T>(record);
        this.metadata = Metadata.of((Object[])new Object[]{this.kafkaMetadata});
        this.commitHandler = commitHandler;
        this.onNack = onNack;
    }

    public T getPayload() {
        return (T)this.kafkaMetadata.getRecord().value();
    }

    @Override
    public K getKey() {
        return this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public long getOffset() {
        return this.kafkaMetadata.getOffset();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return this.commitHandler.handle(this);
    }

    public CompletionStage<Void> nack(Throwable reason) {
        return this.onNack.handle(this, reason);
    }
}

