/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class KafkaConnectorIncomingConfiguration
extends KafkaConnectorCommonConfiguration {
    public KafkaConnectorIncomingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public Optional<String> getTopics() {
        return this.config.getOptionalValue("topics", String.class);
    }

    public Boolean getPattern() {
        return this.config.getOptionalValue("pattern", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getKeyDeserializer() {
        return this.config.getOptionalValue("key.deserializer", String.class).orElse("org.apache.kafka.common.serialization.StringDeserializer");
    }

    public String getValueDeserializer() {
        return (String)this.config.getOptionalValue("value.deserializer", String.class).orElseThrow(() -> new IllegalArgumentException("The attribute `value.deserializer` on connector 'smallrye-kafka' (channel: " + this.getChannel() + ") must be set"));
    }

    public Integer getFetchMinBytes() {
        return this.config.getOptionalValue("fetch.min.bytes", Integer.class).orElse(Integer.valueOf("1"));
    }

    public Optional<String> getGroupId() {
        return this.config.getOptionalValue("group.id", String.class);
    }

    public Boolean getEnableAutoCommit() {
        return this.config.getOptionalValue("enable.auto.commit", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getRetry() {
        return this.config.getOptionalValue("retry", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Integer getRetryAttempts() {
        return this.config.getOptionalValue("retry-attempts", Integer.class).orElse(Integer.valueOf("-1"));
    }

    public Integer getRetryMaxWait() {
        return this.config.getOptionalValue("retry-max-wait", Integer.class).orElse(Integer.valueOf("30"));
    }

    public Boolean getBroadcast() {
        return this.config.getOptionalValue("broadcast", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getAutoOffsetReset() {
        return this.config.getOptionalValue("auto.offset.reset", String.class).orElse("latest");
    }

    public String getFailureStrategy() {
        return this.config.getOptionalValue("failure-strategy", String.class).orElse("fail");
    }

    public Optional<String> getCommitStrategy() {
        return this.config.getOptionalValue("commit-strategy", String.class);
    }

    public Integer getThrottledUnprocessedRecordMaxAgeMs() {
        return this.config.getOptionalValue("throttled.unprocessed-record-max-age.ms", Integer.class).orElse(Integer.valueOf("60000"));
    }

    public Optional<String> getDeadLetterQueueTopic() {
        return this.config.getOptionalValue("dead-letter-queue.topic", String.class);
    }

    public Optional<String> getDeadLetterQueueKeySerializer() {
        return this.config.getOptionalValue("dead-letter-queue.key.serializer", String.class);
    }

    public Optional<String> getDeadLetterQueueValueSerializer() {
        return this.config.getOptionalValue("dead-letter-queue.value.serializer", String.class);
    }

    public Integer getPartitions() {
        return this.config.getOptionalValue("partitions", Integer.class).orElse(Integer.valueOf("1"));
    }

    public Boolean getCloudEvents() {
        return this.config.getOptionalValue("cloud-events", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Optional<String> getConsumerRebalanceListenerName() {
        return this.config.getOptionalValue("consumer-rebalance-listener.name", String.class);
    }

    @Override
    public void validate() {
        super.validate();
        this.getValueDeserializer();
    }
}

