/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.Set;
import java.util.concurrent.CompletionStage;

public interface KafkaCommitHandler {
    default public <K, V> IncomingKafkaRecord<K, V> received(IncomingKafkaRecord<K, V> record) {
        return record;
    }

    default public void terminate() {
    }

    default public void partitionsAssigned(Set<TopicPartition> partitions) {
    }

    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> var1);

    public static enum Strategy {
        LATEST,
        IGNORE,
        THROTTLED;


        public static Strategy from(String s) {
            if (s.equalsIgnoreCase("latest")) {
                return LATEST;
            }
            if (s.equalsIgnoreCase("ignore")) {
                return IGNORE;
            }
            if (s.equalsIgnoreCase("throttled")) {
                return THROTTLED;
            }
            throw KafkaExceptions.ex.illegalArgumentUnknownCommitStrategy(s);
        }
    }
}

