/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.grpc.Context;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnector;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener;
import io.smallrye.reactive.messaging.kafka.commit.ContextHolder;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.commit.KafkaIgnoreCommit;
import io.smallrye.reactive.messaging.kafka.commit.KafkaLatestCommit;
import io.smallrye.reactive.messaging.kafka.commit.KafkaThrottledLatestProcessedCommit;
import io.smallrye.reactive.messaging.kafka.fault.DeserializerWrapper;
import io.smallrye.reactive.messaging.kafka.fault.KafkaDeadLetterQueue;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailStop;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaIgnoreFailure;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigurationCleaner;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.smallrye.reactive.messaging.kafka.impl.RebalanceListeners;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaSource<K, V> {
    private final Multi<IncomingKafkaRecord<K, V>> stream;
    private final io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> consumer;
    private final KafkaFailureHandler failureHandler;
    private final KafkaCommitHandler commitHandler;
    private final KafkaConnectorIncomingConfiguration configuration;
    private final KafkaAdminClient admin;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final Set<String> topics;
    private final Pattern pattern;
    private final boolean isTracingEnabled;
    private final boolean isHealthEnabled;
    private final boolean isReadinessEnabled;
    private final boolean isCloudEventEnabled;
    private final String channel;

    public KafkaSource(io.vertx.mutiny.core.Vertx vertx, String consumerGroup, KafkaConnectorIncomingConfiguration config, Instance<KafkaConsumerRebalanceListener> consumerRebalanceListeners, KafkaCDIEvents kafkaCDIEvents, Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers, int index) {
        boolean retry;
        this.topics = this.getTopics(config);
        if (config.getPattern().booleanValue()) {
            this.pattern = Pattern.compile(config.getTopic().orElseThrow(() -> new IllegalArgumentException("Invalid Kafka incoming configuration for channel `" + config.getChannel() + "`, `pattern` must be used with the `topic` attribute")));
            KafkaLogging.log.configuredPattern(config.getChannel(), this.pattern.toString());
        } else {
            KafkaLogging.log.configuredTopics(config.getChannel(), this.topics);
            this.pattern = null;
        }
        HashMap<String, String> kafkaConfiguration = new HashMap<String, String>();
        this.configuration = config;
        this.isTracingEnabled = this.configuration.getTracingEnabled();
        this.isHealthEnabled = this.configuration.getHealthEnabled();
        this.isReadinessEnabled = this.configuration.getHealthReadinessEnabled();
        this.isCloudEventEnabled = this.configuration.getCloudEvents();
        this.channel = this.configuration.getChannel();
        JsonHelper.asJsonObject(config.config()).forEach(e -> kafkaConfiguration.put((String)e.getKey(), e.getValue().toString()));
        kafkaConfiguration.put("group.id", consumerGroup);
        String servers = config.getBootstrapServers();
        if (!kafkaConfiguration.containsKey("bootstrap.servers")) {
            KafkaLogging.log.configServers("bootstrap.servers", servers);
            kafkaConfiguration.put("bootstrap.servers", servers);
        }
        if (!kafkaConfiguration.containsKey("key.deserializer")) {
            KafkaLogging.log.keyDeserializerOmitted();
            kafkaConfiguration.put("key.deserializer", config.getKeyDeserializer());
        }
        if (!kafkaConfiguration.containsKey("enable.auto.commit")) {
            KafkaLogging.log.disableAutoCommit(config.getChannel());
            kafkaConfiguration.put("enable.auto.commit", "false");
        }
        if (!kafkaConfiguration.containsKey("client.id")) {
            String name = "kafka-consumer-" + config.getChannel();
            if (index != -1) {
                name = name + "-" + index;
            }
            kafkaConfiguration.put("client.id", name);
        }
        String commitStrategy = config.getCommitStrategy().orElse(Boolean.parseBoolean((String)kafkaConfiguration.get("enable.auto.commit")) ? KafkaCommitHandler.Strategy.IGNORE.name() : KafkaCommitHandler.Strategy.THROTTLED.name());
        ConfigurationCleaner.cleanupConsumerConfiguration(kafkaConfiguration);
        DeserializerWrapper keyDeserializer = new DeserializerWrapper((String)kafkaConfiguration.get("key.deserializer"), true, this.getDeserializationHandler(true, deserializationFailureHandlers), this);
        String className = (String)kafkaConfiguration.get("value.deserializer");
        if (className == null) {
            throw KafkaExceptions.ex.missingValueDeserializer(config.getChannel(), config.getChannel());
        }
        DeserializerWrapper valueDeserializer = new DeserializerWrapper(className, false, this.getDeserializationHandler(false, deserializationFailureHandlers), this);
        keyDeserializer.configure(kafkaConfiguration, true);
        valueDeserializer.configure(kafkaConfiguration, false);
        io.vertx.mutiny.kafka.client.consumer.KafkaConsumer kafkaConsumer = this.createKafkaConsumer(vertx, ConfigurationCleaner.asKafkaConfiguration(kafkaConfiguration), keyDeserializer, valueDeserializer);
        kafkaCDIEvents.consumer().fire((Object)kafkaConsumer.getDelegate().unwrap());
        this.commitHandler = this.createCommitHandler(vertx, kafkaConsumer, consumerGroup, config, commitStrategy);
        this.failureHandler = this.createFailureHandler(config, vertx, kafkaConfiguration, kafkaCDIEvents);
        HashMap<String, Object> adminConfiguration = new HashMap<String, Object>(kafkaConfiguration);
        this.admin = config.getHealthEnabled() != false && config.getHealthReadinessEnabled() != false ? KafkaAdminHelper.createAdminClient(vertx, adminConfiguration, config.getChannel(), true) : null;
        this.consumer = kafkaConsumer;
        ConsumerRebalanceListener listener = RebalanceListeners.createRebalanceListener(config, consumerGroup, consumerRebalanceListeners, this.consumer, this.commitHandler);
        RebalanceListeners.inject(this.consumer, listener);
        Multi multi = this.consumer.toMulti().onFailure().invoke(t -> {
            KafkaLogging.log.unableToReadRecord(this.topics, (Throwable)t);
            this.reportFailure((Throwable)t, false);
        });
        if (this.commitHandler instanceof ContextHolder) {
            ((ContextHolder)((Object)this.commitHandler)).capture(this.consumer.getDelegate().asStream());
        }
        if (retry = config.getRetry().booleanValue()) {
            int max = config.getRetryAttempts();
            int maxWait = config.getRetryMaxWait();
            if (max == -1) {
                multi.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost(Long.MAX_VALUE);
            } else {
                multi = multi.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost((long)max);
            }
        }
        Multi incomingMulti = multi.onSubscribe().call(s -> {
            this.consumer.exceptionHandler(t -> this.reportFailure((Throwable)t, false));
            if (this.pattern != null) {
                BiConsumer<UniEmitter, AsyncResult> completionHandler = (e, ar) -> {
                    if (ar.failed()) {
                        e.fail(ar.cause());
                    } else {
                        e.complete(null);
                    }
                };
                return Uni.createFrom().emitter(e -> {
                    KafkaConsumer delegate = this.consumer.getDelegate();
                    delegate.subscribe(this.pattern, ar -> completionHandler.accept((UniEmitter)e, (AsyncResult)ar));
                });
            }
            return this.consumer.subscribe(this.topics);
        }).map(rec -> this.commitHandler.received(new IncomingKafkaRecord(rec, this.commitHandler, this.failureHandler, this.isCloudEventEnabled, this.isTracingEnabled)));
        if (config.getTracingEnabled().booleanValue()) {
            incomingMulti = incomingMulti.onItem().invoke(this::incomingTrace);
        }
        this.stream = incomingMulti.onFailure().invoke(t -> this.reportFailure((Throwable)t, false));
    }

    private <T> DeserializationFailureHandler<T> getDeserializationHandler(boolean isKey, Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers) {
        String name;
        String string = name = isKey ? (String)this.configuration.getKeyDeserializationFailureHandler().orElse(null) : (String)this.configuration.getValueDeserializationFailureHandler().orElse(null);
        if (name == null) {
            return null;
        }
        Instance matching = deserializationFailureHandlers.select(new Annotation[]{NamedLiteral.of((String)name)});
        if (matching.isUnsatisfied()) {
            throw KafkaExceptions.ex.unableToFindDeserializationFailureHandler(name, this.configuration.getChannel());
        }
        if (matching.stream().count() > 1L) {
            throw KafkaExceptions.ex.unableToFindDeserializationFailureHandler(name, this.configuration.getChannel(), (int)matching.stream().count());
        }
        if (matching.stream().count() == 1L) {
            return (DeserializationFailureHandler)matching.get();
        }
        return null;
    }

    private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> createKafkaConsumer(io.vertx.mutiny.core.Vertx vertx, Map<String, Object> kafkaConfiguration, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        org.apache.kafka.clients.consumer.KafkaConsumer underlyingKafkaConsumer = new org.apache.kafka.clients.consumer.KafkaConsumer(kafkaConfiguration, keyDeserializer, valueDeserializer);
        KafkaConsumer bare = KafkaConsumer.create((Vertx)vertx.getDelegate(), (Consumer)underlyingKafkaConsumer);
        return io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance((KafkaConsumer)bare);
    }

    private Set<String> getTopics(KafkaConnectorIncomingConfiguration config) {
        String list = config.getTopics().orElse(null);
        String top = config.getTopic().orElse(null);
        String channel = config.getChannel();
        boolean isPattern = config.getPattern();
        if (list != null && top != null) {
            throw new IllegalArgumentException("The Kafka incoming configuration for channel `" + channel + "` cannot use `topics` and `topic` at the same time");
        }
        if (list != null && isPattern) {
            throw new IllegalArgumentException("The Kafka incoming configuration for channel `" + channel + "` cannot use `topics` and `pattern` at the same time");
        }
        if (list != null) {
            String[] strings = list.split(",");
            return Arrays.stream(strings).map(String::trim).collect(Collectors.toSet());
        }
        if (top != null) {
            return Collections.singleton(top);
        }
        return Collections.singleton(channel);
    }

    public synchronized void reportFailure(Throwable failure, boolean fatal) {
        if (failure instanceof RebalanceInProgressException) {
            KafkaLogging.log.failureReportedDuringRebalance(this.topics, failure);
            return;
        }
        KafkaLogging.log.failureReported(this.topics, failure);
        if (this.failures.size() == 10) {
            this.failures.remove(0);
        }
        this.failures.add(failure);
        if (fatal && this.consumer != null) {
            this.consumer.closeAndForget();
        }
    }

    public void incomingTrace(IncomingKafkaRecord<K, V> kafkaRecord) {
        if (this.isTracingEnabled) {
            TracingMetadata tracingMetadata = TracingMetadata.fromMessage(kafkaRecord).orElse(TracingMetadata.empty());
            Span.Builder spanBuilder = KafkaConnector.TRACER.spanBuilder(kafkaRecord.getTopic() + " receive").setSpanKind(Span.Kind.CONSUMER);
            Context parentSpanContext = tracingMetadata.getPreviousContext();
            if (parentSpanContext != null) {
                spanBuilder.setParent(parentSpanContext);
            } else {
                spanBuilder.setNoParent();
            }
            Span span = spanBuilder.startSpan();
            span.setAttribute("partition", (long)kafkaRecord.getPartition());
            span.setAttribute("offset", kafkaRecord.getOffset());
            span.setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)"kafka");
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION, (Object)kafkaRecord.getTopic());
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)"topic");
            kafkaRecord.injectTracingMetadata(tracingMetadata.withSpan(span));
            span.end();
        }
    }

    private KafkaFailureHandler createFailureHandler(KafkaConnectorIncomingConfiguration config, io.vertx.mutiny.core.Vertx vertx, Map<String, String> kafkaConfiguration, KafkaCDIEvents kafkaCDIEvents) {
        String strategy = config.getFailureStrategy();
        KafkaFailureHandler.Strategy actualStrategy = KafkaFailureHandler.Strategy.from(strategy);
        switch (actualStrategy) {
            case FAIL: {
                return new KafkaFailStop(config.getChannel(), this);
            }
            case IGNORE: {
                return new KafkaIgnoreFailure(config.getChannel());
            }
            case DEAD_LETTER_QUEUE: {
                return KafkaDeadLetterQueue.create(vertx, kafkaConfiguration, config, this, kafkaCDIEvents);
            }
        }
        throw KafkaExceptions.ex.illegalArgumentInvalidFailureStrategy(strategy);
    }

    private KafkaCommitHandler createCommitHandler(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> consumer, String group, KafkaConnectorIncomingConfiguration config, String strategy) {
        KafkaCommitHandler.Strategy actualStrategy = KafkaCommitHandler.Strategy.from(strategy);
        switch (actualStrategy) {
            case LATEST: {
                KafkaLogging.log.commitStrategyForChannel("latest", config.getChannel());
                return new KafkaLatestCommit(vertx, this.configuration, consumer);
            }
            case IGNORE: {
                KafkaLogging.log.commitStrategyForChannel("ignore", config.getChannel());
                return new KafkaIgnoreCommit();
            }
            case THROTTLED: {
                KafkaLogging.log.commitStrategyForChannel("throttled", config.getChannel());
                return KafkaThrottledLatestProcessedCommit.create(vertx, consumer, group, config, this);
            }
        }
        throw KafkaExceptions.ex.illegalArgumentInvalidCommitStrategy(strategy);
    }

    public Multi<IncomingKafkaRecord<K, V>> getStream() {
        return this.stream;
    }

    public void closeQuietly() {
        try {
            this.commitHandler.terminate();
            this.failureHandler.terminate();
            this.consumer.closeAndAwait();
        }
        catch (Throwable e) {
            KafkaLogging.log.exceptionOnClose(e);
        }
        if (this.admin != null) {
            try {
                this.admin.closeAndAwait();
            }
            catch (Throwable e) {
                KafkaLogging.log.exceptionOnClose(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isAlive(HealthReport.HealthReportBuilder builder) {
        if (this.isHealthEnabled) {
            ArrayList<Throwable> actualFailures;
            KafkaSource kafkaSource = this;
            synchronized (kafkaSource) {
                actualFailures = new ArrayList<Throwable>(this.failures);
            }
            if (!actualFailures.isEmpty()) {
                builder.add(this.channel, false, actualFailures.stream().map(Throwable::getMessage).collect(Collectors.joining()));
            } else {
                builder.add(this.channel, true);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.isHealthEnabled && this.isReadinessEnabled) {
            try {
                Set existingTopics = (Set)this.admin.listTopics().await().atMost(Duration.ofMillis(this.configuration.getHealthReadinessTimeout()));
                if (this.pattern == null && existingTopics.containsAll(this.topics)) {
                    builder.add(this.channel, true);
                } else if (this.pattern != null) {
                    boolean ok = existingTopics.stream().anyMatch(s -> this.pattern.matcher((CharSequence)s).matches());
                    if (ok) {
                        builder.add(this.channel, ok);
                    } else {
                        builder.add(this.channel, false, "Unable to find a topic matching the given pattern: " + this.pattern);
                    }
                } else {
                    String missing = this.topics.stream().filter(s -> !existingTopics.contains(s)).collect(Collectors.joining());
                    builder.add(this.channel, false, "Unable to find topic(s): " + missing);
                }
            }
            catch (Exception failed) {
                builder.add(this.channel, false, "No response from broker for channel " + this.channel + " : " + failed);
            }
        }
    }

    public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> getConsumer() {
        return this.consumer;
    }
}

