/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class KafkaSinkReadinessHealth {
    public static final String CONNECTION_COUNT_METRIC_NAME = "connection-count";
    private final KafkaAdminClient admin;
    private final KafkaConnectorOutgoingConfiguration config;
    private final String channel;
    private final Metric metric;
    private final String topic;

    public KafkaSinkReadinessHealth(Vertx vertx, KafkaConnectorOutgoingConfiguration config, Map<String, Object> kafkaConfiguration, Producer<?, ?> producer) {
        this.config = config;
        this.channel = config.getChannel();
        this.topic = config.getTopic().orElse(this.channel);
        if (config.getHealthReadinessTopicVerification().booleanValue()) {
            this.admin = KafkaAdminHelper.createAdminClient(vertx, kafkaConfiguration, config.getChannel(), true);
            this.metric = null;
        } else {
            this.admin = null;
            Map metrics = producer.metrics();
            Metric metric = null;
            for (MetricName metricName : metrics.keySet()) {
                if (!metricName.name().equals(CONNECTION_COUNT_METRIC_NAME)) continue;
                metric = (Metric)metrics.get(metricName);
                break;
            }
            this.metric = metric;
        }
    }

    public void close() {
        if (this.admin != null) {
            try {
                this.admin.closeAndAwait();
            }
            catch (Throwable e) {
                KafkaLogging.log.exceptionOnClose(e);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.admin != null) {
            this.adminBasedHealthCheck(builder);
        } else {
            this.metricsBasedHealthCheck(builder);
        }
    }

    private void metricsBasedHealthCheck(HealthReport.HealthReportBuilder builder) {
        if (this.metric != null) {
            builder.add(this.channel, (Double)this.metric.metricValue() >= 1.0);
        } else {
            builder.add(this.channel, true).build();
        }
    }

    private void adminBasedHealthCheck(HealthReport.HealthReportBuilder builder) {
        try {
            Set topics = (Set)this.admin.listTopics().await().atMost(Duration.ofMillis(this.config.getHealthReadinessTimeout()));
            if (topics.contains(this.topic)) {
                builder.add(this.config.getChannel(), true);
            } else {
                builder.add(this.config.getChannel(), false, "Unable to find topic " + this.topic);
            }
        }
        catch (Exception failed) {
            builder.add(this.config.getChannel(), false, "No response from broker for topic " + this.topic + " : " + failed);
        }
    }
}

