/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class KafkaSourceReadinessHealth {
    public static final String CONNECTION_COUNT_METRIC_NAME = "connection-count";
    private final KafkaAdminClient admin;
    private final KafkaConnectorIncomingConfiguration config;
    private final Pattern pattern;
    private final String channel;
    private final Set<String> topics;
    private final Metric metric;

    public KafkaSourceReadinessHealth(Vertx vertx, KafkaConnectorIncomingConfiguration config, Map<String, String> kafkaConfiguration, Consumer<?, ?> consumer, Set<String> topics, Pattern pattern) {
        this.config = config;
        this.channel = config.getChannel();
        this.topics = topics;
        this.pattern = pattern;
        if (config.getHealthReadinessTopicVerification().booleanValue()) {
            HashMap<String, Object> adminConfiguration = new HashMap<String, Object>(kafkaConfiguration);
            this.admin = KafkaAdminHelper.createAdminClient(vertx, adminConfiguration, config.getChannel(), true);
            this.metric = null;
        } else {
            this.admin = null;
            Map metrics = consumer.metrics();
            Metric metric = null;
            for (MetricName metricName : metrics.keySet()) {
                if (!metricName.name().equals(CONNECTION_COUNT_METRIC_NAME)) continue;
                metric = (Metric)metrics.get(metricName);
                break;
            }
            this.metric = metric;
        }
    }

    public void close() {
        if (this.admin != null) {
            try {
                this.admin.closeAndAwait();
            }
            catch (Throwable e) {
                KafkaLogging.log.exceptionOnClose(e);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.admin != null) {
            this.adminBasedHealthCheck(builder);
        } else {
            this.metricsBasedHealthCheck(builder);
        }
    }

    private void metricsBasedHealthCheck(HealthReport.HealthReportBuilder builder) {
        if (this.metric != null) {
            builder.add(this.channel, (Double)this.metric.metricValue() >= 1.0);
        } else {
            builder.add(this.channel, true).build();
        }
    }

    private void adminBasedHealthCheck(HealthReport.HealthReportBuilder builder) {
        try {
            Set existingTopics = (Set)this.admin.listTopics().await().atMost(Duration.ofMillis(this.config.getHealthReadinessTimeout()));
            if (this.pattern == null && existingTopics.containsAll(this.topics)) {
                builder.add(this.channel, true);
            } else if (this.pattern != null) {
                boolean ok = existingTopics.stream().anyMatch(s -> this.pattern.matcher((CharSequence)s).matches());
                if (ok) {
                    builder.add(this.channel, ok);
                } else {
                    builder.add(this.channel, false, "Unable to find a topic matching the given pattern: " + this.pattern);
                }
            } else {
                String missing = this.topics.stream().filter(s -> !existingTopics.contains(s)).collect(Collectors.joining());
                builder.add(this.channel, false, "Unable to find topic(s): " + missing);
            }
        }
        catch (Exception failed) {
            builder.add(this.channel, false, "No response from broker for channel " + this.channel + " : " + failed);
        }
    }
}

