/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.i18n;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMSG", length=5)
public interface KafkaLogging
extends BasicLogger {
    public static final KafkaLogging log = (KafkaLogging)Logger.getMessageLogger(KafkaLogging.class, (String)"io.smallrye.reactive.messaging.kafka");

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18201, value="Dead queue letter configured with: topic: `%s`, key serializer: `%s`, value serializer: `%s`")
    public void deadLetterConfig(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18202, value="A message sent to channel `%s` has been nacked, sending the record to a dead letter topic %s")
    public void messageNackedDeadLetter(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18203, value="A message sent to channel `%s` has been nacked, fail-stop")
    public void messageNackedFailStop(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18204, value="A message sent to channel `%s` has been nacked, ignored failure is: %s.")
    public void messageNackedIgnore(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18205, value="The full ignored failure is")
    public void messageNackedFullIgnored(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18206, value="Unable to write to Kafka from channel %s (topic: %s)")
    public void unableToWrite(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18206, value="Unable to write to Kafka from channel %s (no topic set)")
    public void unableToWrite(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18207, value="Unable to dispatch message to Kafka")
    public void unableToDispatch(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18209, value="Sending message %s to Kafka topic '%s'")
    public void sendingMessageToTopic(Message<?> var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18210, value="Unable to send a record to Kafka ")
    public void unableToSendRecord(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18211, value="Message %s sent successfully to Kafka topic '%s'")
    public void successfullyToTopic(Message<?> var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18212, value="Message %s was not sent to Kafka topic '%s' - nacking message")
    public void nackingMessage(Message<?> var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18213, value="Setting %s to %s")
    public void configServers(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18214, value="Key deserializer omitted, using String as default")
    public void keyDeserializerOmitted();

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18215, value="An error has been caught while closing the Kafka Write Stream")
    public void errorWhileClosingWriteStream(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18216, value="No `group.id` set in the configuration, generate a random id: %s")
    public void noGroupId(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18217, value="Unable to read a record from Kafka topics '%s'")
    public void unableToReadRecord(Set<String> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18218, value="An exception has been caught while closing the Kafka consumer")
    public void exceptionOnClose(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18219, value="Loading KafkaConsumerRebalanceListener from configured name '%s'")
    public void loadingConsumerRebalanceListenerFromConfiguredName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18220, value="Loading KafkaConsumerRebalanceListener from group id '%s'")
    public void loadingConsumerRebalanceListenerFromGroupId(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18222, value="Unable to execute consumer revoked re-balance listener for group '%s'")
    public void unableToExecuteConsumerRevokedRebalanceListener(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18224, value="Executing consumer revoked re-balance listener for group '%s'")
    public void executingConsumerRevokedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18225, value="Executed consumer assigned re-balance listener for group '%s'")
    public void executedConsumerAssignedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18226, value="Executed consumer revoked re-balance listener for group '%s'")
    public void executedConsumerRevokedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18227, value="Re-enabling consumer for group '%s'. This consumer was paused because of a re-balance failure.")
    public void reEnablingConsumerForGroup(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18228, value="A failure has been reported for Kafka topics '%s'")
    public void failureReported(Set<String> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18242, value="A failure has been reported during a rebalance - the operation will be retried: '%s'")
    public void failureReportedDuringRebalance(Set<String> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18229, value="Configured topics for channel '%s': %s")
    public void configuredTopics(String var1, Set<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18230, value="Configured topics matching pattern for channel '%s': %s")
    public void configuredPattern(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18231, value="The record %d from topic-partition '%s' has waited for %s seconds to be acknowledged. This waiting time is greater than the configured threshold (%d ms). At the moment %d messages from this partition are awaiting acknowledgement. The last committed offset for this partition was %d. This error is due to a potential issue in the application which does not acknowledged the records in a timely fashion. The connector cannot commit as a record processing has not completed.")
    public void waitingForAckForTooLong(long var1, TopicPartition var3, long var4, long var6, long var8, long var10);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18232, value="Will commit for group '%s' every %d milliseconds.")
    public void settingCommitInterval(String var1, long var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18233, value="Invalid value serializer to write a structured Cloud Event. Found %s, expected the org.apache.kafka.common.serialization.StringSerializer")
    public void invalidValueSerializerForStructuredCloudEvent(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18234, value="Auto-commit disabled for channel %s")
    public void disableAutoCommit(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18235, value="Will not health check throttled commit strategy for group '%s'.")
    public void disableThrottledCommitStrategyHealthCheck(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18236, value="Will mark throttled commit strategy for group '%s' as unhealthy if records go more than %d milliseconds without being processed.")
    public void setThrottledCommitStrategyReceivedRecordMaxAge(String var1, long var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18237, value="Setting client.id for Kafka producer to %s")
    public void setKafkaProducerClientId(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18239, value="Received acknowledgement for record %d on '%s' (consumer group: '%s'). Ignoring it because the partition is not assigned to the consume anymore. Record will likely be processed again. Current assignments are %s.")
    public void acknowledgementFromRevokedTopicPartition(long var1, TopicPartition var3, String var4, Collection<TopicPartition> var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18240, value="'%s' commit strategy used for channel '%s'")
    public void commitStrategyForChannel(String var1, String var2);

    @LogMessage(level=Logger.Level.FATAL)
    @org.jboss.logging.annotations.Message(id=18241, value="The deserialization failure handler `%s` throws an exception")
    public void deserializationFailureHandlerFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18243, value="Shutting down - Pausing all topic-partitions")
    public void pauseAllPartitionOnTermination();

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18244, value="Shutting down - Waiting for message processing to complete, %d messages still in processing")
    public void waitingForMessageProcessing(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18245, value="There are still %d unprocessed messages after the closing timeout")
    public void messageStillUnprocessedAfterTimeout(long var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18246, value="Pausing Kafka consumption for channel %s, queue size %s is more than %s")
    public void pausingChannel(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18247, value="Resuming Kafka consumption for channel %s, queue size %s is less than %s")
    public void resumingChannel(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18248, value="Key serializer omitted, using String as default")
    public void keySerializerOmitted();

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18249, value="Unable to recover from the deserialization failure (topic: %s), configure a DeserializationFailureHandler to recover from errors.")
    public void unableToDeserializeMessage(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18250, value="The configuration property '%s' is deprecated and is replaced by '%s'.")
    public void deprecatedConfig(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18251, value="Committed %s")
    public void committed(Map<TopicPartition, OffsetAndMetadata> var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18252, value="Failed to commit %s, it will be re-attempted")
    public void failedToCommit(Map<TopicPartition, OffsetAndMetadata> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18253, value="Removing topic-partition '%s' from the store - the partition is not assigned to the consumer anymore. Current assignments are: %s")
    public void removingPartitionFromStore(TopicPartition var1, Collection<TopicPartition> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18254, value="Topic-partition '%s' has been revoked - going to commit offset %d")
    public void partitionRevokedCollectingRecordsToCommit(TopicPartition var1, long var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18255, value="Received a record from topic-partition '%s' at offset %d, while the last committed offset is %d - Ignoring record")
    public void receivedOutdatedOffset(TopicPartition var1, long var2, long var4);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18256, value="Initialize record store for topic-partition '%s' at position %d.")
    public void initializeStoreAtPosition(TopicPartition var1, long var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18257, value="Kafka consumer %s, connected to Kafka brokers '%s', belongs to the '%s' consumer group and is configured to poll records from %s")
    public void connectedToKafka(String var1, String var2, String var3, Set<String> var4);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18258, value="Kafka producer %s, connected to Kafka brokers '%s', is configured to write records to '%s'")
    public void connectedToKafka(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18259, value="Kafka latest commit strategy failed to commit record from topic-partition '%s' at offset %d")
    public void failedToCommitAsync(TopicPartition var1, long var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18260, value="Unable to recover from the serialization failure (topic: %s), configure a SerializationFailureHandler to recover from errors.")
    public void unableToSerializeMessage(String var1, @Cause Throwable var2);
}

