/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.i18n;

import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class KafkaLogging_$logger
extends DelegatingBasicLogger
implements KafkaLogging,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = KafkaLogging_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public KafkaLogging_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void deadLetterConfig(String deadQueueTopic, String keySerializer, String valueSerializer) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.deadLetterConfig$str(), (Object)deadQueueTopic, (Object)keySerializer, (Object)valueSerializer);
    }

    protected String deadLetterConfig$str() {
        return "SRMSG18201: Dead queue letter configured with: topic: `%s`, key serializer: `%s`, value serializer: `%s`";
    }

    @Override
    public final void messageNackedDeadLetter(String channel, String topic) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.messageNackedDeadLetter$str(), (Object)channel, (Object)topic);
    }

    protected String messageNackedDeadLetter$str() {
        return "SRMSG18202: A message sent to channel `%s` has been nacked, sending the record to a dead letter topic %s";
    }

    @Override
    public final void messageNackedFailStop(String channel) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.messageNackedFailStop$str(), (Object)channel);
    }

    protected String messageNackedFailStop$str() {
        return "SRMSG18203: A message sent to channel `%s` has been nacked, fail-stop";
    }

    @Override
    public final void messageNackedIgnore(String channel, String reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.messageNackedIgnore$str(), (Object)channel, (Object)reason);
    }

    protected String messageNackedIgnore$str() {
        return "SRMSG18204: A message sent to channel `%s` has been nacked, ignored failure is: %s.";
    }

    @Override
    public final void messageNackedFullIgnored(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.messageNackedFullIgnored$str(), new Object[0]);
    }

    protected String messageNackedFullIgnored$str() {
        return "SRMSG18205: The full ignored failure is";
    }

    @Override
    public final void unableToWrite(String channel, String topic, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToWrite2$str(), (Object)channel, (Object)topic);
    }

    protected String unableToWrite2$str() {
        return "SRMSG18206: Unable to write to Kafka from channel %s (topic: %s)";
    }

    @Override
    public final void unableToWrite(String channel, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToWrite1$str(), (Object)channel);
    }

    protected String unableToWrite1$str() {
        return "SRMSG18206: Unable to write to Kafka from channel %s (no topic set)";
    }

    @Override
    public final void unableToDispatch(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToDispatch$str(), new Object[0]);
    }

    protected String unableToDispatch$str() {
        return "SRMSG18207: Unable to dispatch message to Kafka";
    }

    @Override
    public final void sendingMessageToTopic(Message<?> message, String topic) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendingMessageToTopic$str(), message, (Object)topic);
    }

    protected String sendingMessageToTopic$str() {
        return "SRMSG18209: Sending message %s to Kafka topic '%s'";
    }

    @Override
    public final void unableToSendRecord(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToSendRecord$str(), new Object[0]);
    }

    protected String unableToSendRecord$str() {
        return "SRMSG18210: Unable to send a record to Kafka ";
    }

    @Override
    public final void successfullyToTopic(Message<?> message, String topic) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.successfullyToTopic$str(), message, (Object)topic);
    }

    protected String successfullyToTopic$str() {
        return "SRMSG18211: Message %s sent successfully to Kafka topic '%s'";
    }

    @Override
    public final void nackingMessage(Message<?> message, String topic, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.nackingMessage$str(), message, (Object)topic);
    }

    protected String nackingMessage$str() {
        return "SRMSG18212: Message %s was not sent to Kafka topic '%s' - nacking message";
    }

    @Override
    public final void configServers(String serverConfig, String servers) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configServers$str(), (Object)serverConfig, (Object)servers);
    }

    protected String configServers$str() {
        return "SRMSG18213: Setting %s to %s";
    }

    @Override
    public final void keyDeserializerOmitted() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.keyDeserializerOmitted$str(), new Object[0]);
    }

    protected String keyDeserializerOmitted$str() {
        return "SRMSG18214: Key deserializer omitted, using String as default";
    }

    @Override
    public final void errorWhileClosingWriteStream(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.errorWhileClosingWriteStream$str(), new Object[0]);
    }

    protected String errorWhileClosingWriteStream$str() {
        return "SRMSG18215: An error has been caught while closing the Kafka Write Stream";
    }

    @Override
    public final void noGroupId(String randomId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noGroupId$str(), (Object)randomId);
    }

    protected String noGroupId$str() {
        return "SRMSG18216: No `group.id` set in the configuration, generate a random id: %s";
    }

    @Override
    public final void unableToReadRecord(Set<String> topics, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToReadRecord$str(), topics);
    }

    protected String unableToReadRecord$str() {
        return "SRMSG18217: Unable to read a record from Kafka topics '%s'";
    }

    @Override
    public final void exceptionOnClose(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.exceptionOnClose$str(), new Object[0]);
    }

    protected String exceptionOnClose$str() {
        return "SRMSG18218: An exception has been caught while closing the Kafka consumer";
    }

    @Override
    public final void loadingConsumerRebalanceListenerFromConfiguredName(String configuredName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadingConsumerRebalanceListenerFromConfiguredName$str(), (Object)configuredName);
    }

    protected String loadingConsumerRebalanceListenerFromConfiguredName$str() {
        return "SRMSG18219: Loading KafkaConsumerRebalanceListener from configured name '%s'";
    }

    @Override
    public final void loadingConsumerRebalanceListenerFromGroupId(String consumerGroup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadingConsumerRebalanceListenerFromGroupId$str(), (Object)consumerGroup);
    }

    protected String loadingConsumerRebalanceListenerFromGroupId$str() {
        return "SRMSG18220: Loading KafkaConsumerRebalanceListener from group id '%s'";
    }

    @Override
    public final void unableToExecuteConsumerRevokedRebalanceListener(String consumerGroup, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToExecuteConsumerRevokedRebalanceListener$str(), (Object)consumerGroup);
    }

    protected String unableToExecuteConsumerRevokedRebalanceListener$str() {
        return "SRMSG18222: Unable to execute consumer revoked re-balance listener for group '%s'";
    }

    @Override
    public final void executingConsumerRevokedRebalanceListener(String consumerGroup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.executingConsumerRevokedRebalanceListener$str(), (Object)consumerGroup);
    }

    protected String executingConsumerRevokedRebalanceListener$str() {
        return "SRMSG18224: Executing consumer revoked re-balance listener for group '%s'";
    }

    @Override
    public final void executedConsumerAssignedRebalanceListener(String consumerGroup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.executedConsumerAssignedRebalanceListener$str(), (Object)consumerGroup);
    }

    protected String executedConsumerAssignedRebalanceListener$str() {
        return "SRMSG18225: Executed consumer assigned re-balance listener for group '%s'";
    }

    @Override
    public final void executedConsumerRevokedRebalanceListener(String consumerGroup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.executedConsumerRevokedRebalanceListener$str(), (Object)consumerGroup);
    }

    protected String executedConsumerRevokedRebalanceListener$str() {
        return "SRMSG18226: Executed consumer revoked re-balance listener for group '%s'";
    }

    @Override
    public final void reEnablingConsumerForGroup(String consumerGroup) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.reEnablingConsumerForGroup$str(), (Object)consumerGroup);
    }

    protected String reEnablingConsumerForGroup$str() {
        return "SRMSG18227: Re-enabling consumer for group '%s'. This consumer was paused because of a re-balance failure.";
    }

    @Override
    public final void failureReported(Set<String> topics, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failureReported$str(), topics);
    }

    protected String failureReported$str() {
        return "SRMSG18228: A failure has been reported for Kafka topics '%s'";
    }

    @Override
    public final void failureReportedDuringRebalance(Set<String> topics, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failureReportedDuringRebalance$str(), topics);
    }

    protected String failureReportedDuringRebalance$str() {
        return "SRMSG18242: A failure has been reported during a rebalance - the operation will be retried: '%s'";
    }

    @Override
    public final void configuredTopics(String channel, Set<String> topics) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configuredTopics$str(), (Object)channel, topics);
    }

    protected String configuredTopics$str() {
        return "SRMSG18229: Configured topics for channel '%s': %s";
    }

    @Override
    public final void configuredPattern(String channel, String pattern) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configuredPattern$str(), (Object)channel, (Object)pattern);
    }

    protected String configuredPattern$str() {
        return "SRMSG18230: Configured topics matching pattern for channel '%s': %s";
    }

    @Override
    public final void waitingForAckForTooLong(long offset, TopicPartition topicPartition, long delay, long configInMs, long queueSize, long lastCommittedOffset) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.waitingForAckForTooLong$str(), new Object[]{offset, topicPartition, delay, configInMs, queueSize, lastCommittedOffset});
    }

    protected String waitingForAckForTooLong$str() {
        return "SRMSG18231: The record %d from topic-partition '%s' has waited for %s seconds to be acknowledged. This waiting time is greater than the configured threshold (%d ms). At the moment %d messages from this partition are awaiting acknowledgement. The last committed offset for this partition was %d. This error is due to a potential issue in the application which does not acknowledged the records in a timely fashion. The connector cannot commit as a record processing has not completed.";
    }

    @Override
    public final void settingCommitInterval(String group, long commitInterval) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.settingCommitInterval$str(), (Object)group, (Object)commitInterval);
    }

    protected String settingCommitInterval$str() {
        return "SRMSG18232: Will commit for group '%s' every %d milliseconds.";
    }

    @Override
    public final void invalidValueSerializerForStructuredCloudEvent(String serializer) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidValueSerializerForStructuredCloudEvent$str(), (Object)serializer);
    }

    protected String invalidValueSerializerForStructuredCloudEvent$str() {
        return "SRMSG18233: Invalid value serializer to write a structured Cloud Event. Found %s, expected the org.apache.kafka.common.serialization.StringSerializer";
    }

    @Override
    public final void disableAutoCommit(String channel) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.disableAutoCommit$str(), (Object)channel);
    }

    protected String disableAutoCommit$str() {
        return "SRMSG18234: Auto-commit disabled for channel %s";
    }

    @Override
    public final void disableThrottledCommitStrategyHealthCheck(String group) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.disableThrottledCommitStrategyHealthCheck$str(), (Object)group);
    }

    protected String disableThrottledCommitStrategyHealthCheck$str() {
        return "SRMSG18235: Will not health check throttled commit strategy for group '%s'.";
    }

    @Override
    public final void setThrottledCommitStrategyReceivedRecordMaxAge(String group, long unprocessedRecordMaxAge) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.setThrottledCommitStrategyReceivedRecordMaxAge$str(), (Object)group, (Object)unprocessedRecordMaxAge);
    }

    protected String setThrottledCommitStrategyReceivedRecordMaxAge$str() {
        return "SRMSG18236: Will mark throttled commit strategy for group '%s' as unhealthy if records go more than %d milliseconds without being processed.";
    }

    @Override
    public final void setKafkaProducerClientId(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.setKafkaProducerClientId$str(), (Object)name);
    }

    protected String setKafkaProducerClientId$str() {
        return "SRMSG18237: Setting client.id for Kafka producer to %s";
    }

    @Override
    public final void acknowledgementFromRevokedTopicPartition(long offset, TopicPartition topicPartition, String groupId, Collection<TopicPartition> assignments) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.acknowledgementFromRevokedTopicPartition$str(), new Object[]{offset, topicPartition, groupId, assignments});
    }

    protected String acknowledgementFromRevokedTopicPartition$str() {
        return "SRMSG18239: Received acknowledgement for record %d on '%s' (consumer group: '%s'). Ignoring it because the partition is not assigned to the consume anymore. Record will likely be processed again. Current assignments are %s.";
    }

    @Override
    public final void commitStrategyForChannel(String strategy, String channel) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.commitStrategyForChannel$str(), (Object)strategy, (Object)channel);
    }

    protected String commitStrategyForChannel$str() {
        return "SRMSG18240: '%s' commit strategy used for channel '%s'";
    }

    @Override
    public final void deserializationFailureHandlerFailure(String instance, Throwable t) {
        this.log.logf(FQCN, Logger.Level.FATAL, t, this.deserializationFailureHandlerFailure$str(), (Object)instance);
    }

    protected String deserializationFailureHandlerFailure$str() {
        return "SRMSG18241: The deserialization failure handler `%s` throws an exception";
    }

    @Override
    public final void pauseAllPartitionOnTermination() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.pauseAllPartitionOnTermination$str(), new Object[0]);
    }

    protected String pauseAllPartitionOnTermination$str() {
        return "SRMSG18243: Shutting down - Pausing all topic-partitions";
    }

    @Override
    public final void waitingForMessageProcessing(long p) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.waitingForMessageProcessing$str(), (Object)p);
    }

    protected String waitingForMessageProcessing$str() {
        return "SRMSG18244: Shutting down - Waiting for message processing to complete, %d messages still in processing";
    }

    @Override
    public final void messageStillUnprocessedAfterTimeout(long unprocessed) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.messageStillUnprocessedAfterTimeout$str(), (Object)unprocessed);
    }

    protected String messageStillUnprocessedAfterTimeout$str() {
        return "SRMSG18245: There are still %d unprocessed messages after the closing timeout";
    }

    @Override
    public final void pausingChannel(String channel, int queueSize, int maxQueueSize) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.pausingChannel$str(), (Object)channel, (Object)queueSize, (Object)maxQueueSize);
    }

    protected String pausingChannel$str() {
        return "SRMSG18246: Pausing Kafka consumption for channel %s, queue size %s is more than %s";
    }

    @Override
    public final void resumingChannel(String channel, int queueSize, int halfMaxQueueSize) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.resumingChannel$str(), (Object)channel, (Object)queueSize, (Object)halfMaxQueueSize);
    }

    protected String resumingChannel$str() {
        return "SRMSG18247: Resuming Kafka consumption for channel %s, queue size %s is less than %s";
    }

    @Override
    public final void keySerializerOmitted() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.keySerializerOmitted$str(), new Object[0]);
    }

    protected String keySerializerOmitted$str() {
        return "SRMSG18248: Key serializer omitted, using String as default";
    }

    @Override
    public final void unableToDeserializeMessage(String topic, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToDeserializeMessage$str(), (Object)topic);
    }

    protected String unableToDeserializeMessage$str() {
        return "SRMSG18249: Unable to recover from the deserialization failure (topic: %s), configure a DeserializationFailureHandler to recover from errors.";
    }

    @Override
    public final void deprecatedConfig(String deprecated, String replace) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedConfig$str(), (Object)deprecated, (Object)replace);
    }

    protected String deprecatedConfig$str() {
        return "SRMSG18250: The configuration property '%s' is deprecated and is replaced by '%s'.";
    }

    @Override
    public final void committed(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.committed$str(), offsets);
    }

    protected String committed$str() {
        return "SRMSG18251: Committed %s";
    }

    @Override
    public final void failedToCommit(Map<TopicPartition, OffsetAndMetadata> offsets, Throwable failure) {
        this.log.logf(FQCN, Logger.Level.WARN, failure, this.failedToCommit$str(), offsets);
    }

    protected String failedToCommit$str() {
        return "SRMSG18252: Failed to commit %s, it will be re-attempted";
    }

    @Override
    public final void removingPartitionFromStore(TopicPartition tp, Collection<TopicPartition> assignments) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.removingPartitionFromStore$str(), (Object)tp, assignments);
    }

    protected String removingPartitionFromStore$str() {
        return "SRMSG18253: Removing topic-partition '%s' from the store - the partition is not assigned to the consumer anymore. Current assignments are: %s";
    }

    @Override
    public final void partitionRevokedCollectingRecordsToCommit(TopicPartition partition, long commit) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.partitionRevokedCollectingRecordsToCommit$str(), (Object)partition, (Object)commit);
    }

    protected String partitionRevokedCollectingRecordsToCommit$str() {
        return "SRMSG18254: Topic-partition '%s' has been revoked - going to commit offset %d";
    }

    @Override
    public final void receivedOutdatedOffset(TopicPartition topicPartition, long offset, long lastCommitted) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.receivedOutdatedOffset$str(), (Object)topicPartition, (Object)offset, (Object)lastCommitted);
    }

    protected String receivedOutdatedOffset$str() {
        return "SRMSG18255: Received a record from topic-partition '%s' at offset %d, while the last committed offset is %d - Ignoring record";
    }

    @Override
    public final void initializeStoreAtPosition(TopicPartition topicPartition, long position) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initializeStoreAtPosition$str(), (Object)topicPartition, (Object)position);
    }

    protected String initializeStoreAtPosition$str() {
        return "SRMSG18256: Initialize record store for topic-partition '%s' at position %d.";
    }

    @Override
    public final void connectedToKafka(String id, String bootstrapServers, String consumerGroup, Set<String> topics) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectedToKafka4$str(), new Object[]{id, bootstrapServers, consumerGroup, topics});
    }

    protected String connectedToKafka4$str() {
        return "SRMSG18257: Kafka consumer %s, connected to Kafka brokers '%s', belongs to the '%s' consumer group and is configured to poll records from %s";
    }

    @Override
    public final void connectedToKafka(String id, String bootstrapServers, String topic) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectedToKafka3$str(), (Object)id, (Object)bootstrapServers, (Object)topic);
    }

    protected String connectedToKafka3$str() {
        return "SRMSG18258: Kafka producer %s, connected to Kafka brokers '%s', is configured to write records to '%s'";
    }

    @Override
    public final void failedToCommitAsync(TopicPartition topicPartition, long offset) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToCommitAsync$str(), (Object)topicPartition, (Object)offset);
    }

    protected String failedToCommitAsync$str() {
        return "SRMSG18259: Kafka latest commit strategy failed to commit record from topic-partition '%s' at offset %d";
    }

    @Override
    public final void unableToSerializeMessage(String topic, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToSerializeMessage$str(), (Object)topic);
    }

    protected String unableToSerializeMessage$str() {
        return "SRMSG18260: Unable to recover from the serialization failure (topic: %s), configure a SerializationFailureHandler to recover from errors.";
    }
}

