/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.fault.DeserializerWrapper;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigurationCleaner;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaPollingThread;
import io.smallrye.reactive.messaging.kafka.impl.KafkaRecordBatchStream;
import io.smallrye.reactive.messaging.kafka.impl.KafkaRecordStream;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import io.smallrye.reactive.messaging.kafka.impl.RebalanceListeners;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.vertx.core.Context;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;

public class ReactiveKafkaConsumer<K, V>
implements KafkaConsumer<K, V> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean polling = new AtomicBoolean(false);
    private final KafkaSource<K, V> source;
    private Consumer<K, V> consumer;
    private final KafkaConnectorIncomingConfiguration configuration;
    private final Duration pollTimeout;
    private ConsumerRebalanceListener rebalanceListener;
    private final AtomicBoolean paused = new AtomicBoolean();
    private final ScheduledExecutorService kafkaWorker;
    private final KafkaRecordStream<K, V> stream;
    private final KafkaRecordBatchStream<K, V> batchStream;
    private final Map<String, Object> kafkaConfiguration;

    public ReactiveKafkaConsumer(KafkaConnectorIncomingConfiguration config, KafkaSource<K, V> source) {
        this.configuration = config;
        this.source = source;
        this.kafkaConfiguration = this.getKafkaConsumerConfiguration(this.configuration, source.getConsumerGroup(), source.getConsumerIndex());
        Instance<DeserializationFailureHandler<?>> failureHandlers = source.getDeserializationFailureHandlers();
        String keyDeserializerCN = (String)this.kafkaConfiguration.get("key.deserializer");
        String valueDeserializerCN = (String)this.kafkaConfiguration.get("value.deserializer");
        if (valueDeserializerCN == null) {
            throw KafkaExceptions.ex.missingValueDeserializer(config.getChannel(), config.getChannel());
        }
        DeserializerWrapper keyDeserializer = new DeserializerWrapper(keyDeserializerCN, true, this.getDeserializationHandler(true, failureHandlers), source, config.getFailOnDeserializationFailure());
        DeserializerWrapper valueDeserializer = new DeserializerWrapper(valueDeserializerCN, false, this.getDeserializationHandler(false, failureHandlers), source, config.getFailOnDeserializationFailure());
        keyDeserializer.configure(this.kafkaConfiguration, true);
        valueDeserializer.configure(this.kafkaConfiguration, false);
        this.pollTimeout = Duration.ofMillis(config.getPollTimeout().intValue());
        this.kafkaWorker = Executors.newSingleThreadScheduledExecutor(KafkaPollingThread::new);
        this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(this.kafkaConfiguration, keyDeserializer, valueDeserializer);
        this.stream = new KafkaRecordStream(this, config, source.getContext().getDelegate());
        this.batchStream = new KafkaRecordBatchStream(this, config, source.getContext().getDelegate());
    }

    public void setRebalanceListener() {
        try {
            this.rebalanceListener = RebalanceListeners.createRebalanceListener(this, this.configuration, this.source.getConsumerGroup(), this.source.getConsumerRebalanceListeners(), this.source.getCommitHandler());
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public ConsumerRebalanceListener getRebalanceListener() {
        return this.rebalanceListener;
    }

    @Override
    @CheckReturnValue
    public <T> Uni<T> runOnPollingThread(Function<Consumer<K, V>, T> action) {
        return Uni.createFrom().item(() -> action.apply(this.consumer)).runSubscriptionOn((Executor)this.kafkaWorker);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> runOnPollingThread(java.util.function.Consumer<Consumer<K, V>> action) {
        return Uni.createFrom().item(() -> {
            action.accept(this.consumer);
            return null;
        }).runSubscriptionOn((Executor)this.kafkaWorker);
    }

    Uni<Void> executeWithDelay(Runnable action, Duration delay) {
        return Uni.createFrom().emitter(e -> this.kafkaWorker.schedule(() -> {
            try {
                action.run();
            }
            catch (Exception ex) {
                e.fail((Throwable)ex);
                return;
            }
            e.complete(null);
        }, delay.toMillis(), TimeUnit.MILLISECONDS));
    }

    Uni<ConsumerRecords<K, V>> poll() {
        if (this.polling.compareAndSet(false, true)) {
            return this.runOnPollingThread((Function)c -> {
                if (System.getSecurityManager() == null) {
                    return this.paused.get() ? c.poll(Duration.ZERO) : c.poll(this.pollTimeout);
                }
                return (ConsumerRecords)AccessController.doPrivileged(new PrivilegedAction<ConsumerRecords<K, V>>((Consumer)c){
                    final /* synthetic */ Consumer val$c;
                    {
                        this.val$c = consumer;
                    }

                    @Override
                    public ConsumerRecords<K, V> run() {
                        return ReactiveKafkaConsumer.this.paused.get() ? this.val$c.poll(Duration.ZERO) : this.val$c.poll(ReactiveKafkaConsumer.this.pollTimeout);
                    }
                });
            }).eventually(() -> this.polling.set(false)).onFailure(WakeupException.class).recoverWithItem((Object)ConsumerRecords.EMPTY);
        }
        return Uni.createFrom().item((Object)ConsumerRecords.EMPTY);
    }

    @Override
    @CheckReturnValue
    public Uni<Set<TopicPartition>> pause() {
        if (this.paused.compareAndSet(false, true)) {
            return this.runOnPollingThread((Function)c -> {
                Set tps = this.consumer.assignment();
                this.consumer.pause((Collection)tps);
                return tps;
            });
        }
        return this.runOnPollingThread((Function)Consumer::paused);
    }

    @Override
    @CheckReturnValue
    public Uni<Set<TopicPartition>> paused() {
        return this.runOnPollingThread((Function)Consumer::paused);
    }

    @Override
    @CheckReturnValue
    public Uni<Map<TopicPartition, OffsetAndMetadata>> committed(TopicPartition ... tps) {
        return this.runOnPollingThread((Function)c -> c.committed(new LinkedHashSet<TopicPartition>(Arrays.asList(tps))));
    }

    @CheckReturnValue
    public Multi<ConsumerRecord<K, V>> subscribe(Set<String> topics) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.subscribe((Collection)topics, this.rebalanceListener)).onItem().transformToMulti(v -> this.stream);
    }

    @CheckReturnValue
    public Multi<ConsumerRecord<K, V>> subscribe(Pattern topics) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.subscribe(topics, this.rebalanceListener)).onItem().transformToMulti(v -> this.stream);
    }

    @CheckReturnValue
    Multi<ConsumerRecords<K, V>> subscribeBatch(Set<String> topics) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.subscribe((Collection)topics, this.rebalanceListener)).onItem().transformToMulti(v -> this.batchStream);
    }

    @CheckReturnValue
    Multi<ConsumerRecords<K, V>> subscribeBatch(Pattern topics) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.subscribe(topics, this.rebalanceListener)).onItem().transformToMulti(v -> this.batchStream);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> resume() {
        if (this.paused.get()) {
            return this.runOnPollingThread((Consumer<K, V> c) -> {
                Set assignment = c.assignment();
                this.consumer.resume((Collection)assignment);
            }).invoke(() -> this.paused.set(false));
        }
        return Uni.createFrom().voidItem();
    }

    @Override
    @CheckReturnValue
    public Uni<ConsumerGroupMetadata> consumerGroupMetadata() {
        return this.runOnPollingThread((Function)Consumer::groupMetadata);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> resetToLastCommittedPositions() {
        return this.runOnPollingThread((Consumer<K, V> c) -> {
            Set assignments = c.assignment();
            c.pause((Collection)assignments);
            Map committed = c.committed(assignments);
            for (TopicPartition tp : assignments) {
                OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)committed.get(tp);
                if (offsetAndMetadata != null) {
                    c.seek(tp, offsetAndMetadata.offset());
                    continue;
                }
                c.seekToBeginning(Collections.singleton(tp));
            }
            this.removeFromQueueRecordsFromTopicPartitions(assignments);
            c.resume((Collection)c.assignment());
        });
    }

    private Map<String, Object> getKafkaConsumerConfiguration(KafkaConnectorIncomingConfiguration configuration, String consumerGroup, int index) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonHelper.asJsonObject(configuration.config()).forEach(e -> map.put((String)e.getKey(), e.getValue().toString()));
        map.put("group.id", consumerGroup);
        if (!map.containsKey("reconnect.backoff.max.ms")) {
            map.put("reconnect.backoff.max.ms", "10000");
        }
        String servers = configuration.getBootstrapServers();
        if (!map.containsKey("bootstrap.servers")) {
            KafkaLogging.log.configServers("bootstrap.servers", servers);
            map.put("bootstrap.servers", servers);
        }
        if (!map.containsKey("key.deserializer")) {
            KafkaLogging.log.keyDeserializerOmitted();
            map.put("key.deserializer", configuration.getKeyDeserializer());
        }
        if (!map.containsKey("enable.auto.commit")) {
            KafkaLogging.log.disableAutoCommit(configuration.getChannel());
            map.put("enable.auto.commit", "false");
        }
        if (index == -1) {
            map.computeIfAbsent("client.id", k -> "kafka-consumer-" + configuration.getChannel());
        } else {
            String configuredClientId = (String)map.get("client.id");
            configuredClientId = configuredClientId == null ? "kafka-consumer-" + configuration.getChannel() + "-" + index : configuredClientId + "-" + index;
            map.put("client.id", configuredClientId);
        }
        ConfigurationCleaner.cleanupConsumerConfiguration(map);
        return map;
    }

    private <T> DeserializationFailureHandler<T> getDeserializationHandler(boolean isKey, Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers) {
        return ReactiveKafkaConsumer.createDeserializationFailureHandler(isKey, deserializationFailureHandlers, this.configuration);
    }

    private static <T> DeserializationFailureHandler<T> createDeserializationFailureHandler(boolean isKey, Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers, KafkaConnectorIncomingConfiguration configuration) {
        String name;
        String string = name = isKey ? (String)configuration.getKeyDeserializationFailureHandler().orElse(null) : (String)configuration.getValueDeserializationFailureHandler().orElse(null);
        if (name == null) {
            return null;
        }
        Instance matching = deserializationFailureHandlers.select(new Annotation[]{Identifier.Literal.of((String)name)});
        if (matching.isUnsatisfied() && !(matching = deserializationFailureHandlers.select(new Annotation[]{NamedLiteral.of((String)name)})).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        if (matching.isUnsatisfied()) {
            throw KafkaExceptions.ex.unableToFindDeserializationFailureHandler(name, configuration.getChannel());
        }
        if (matching.stream().count() > 1L) {
            throw KafkaExceptions.ex.unableToFindDeserializationFailureHandler(name, configuration.getChannel(), (int)matching.stream().count());
        }
        if (matching.stream().count() == 1L) {
            return (DeserializationFailureHandler)matching.get();
        }
        return null;
    }

    public String get(String attribute) {
        return (String)this.kafkaConfiguration.get(attribute);
    }

    @Override
    public Consumer<K, V> unwrap() {
        return this.consumer;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> commit(Map<TopicPartition, OffsetAndMetadata> map) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.commitSync(map));
    }

    @CheckReturnValue
    public Uni<Void> commitAsync(Map<TopicPartition, OffsetAndMetadata> map) {
        return Uni.createFrom().emitter(e -> this.consumer.commitAsync(map, (offsets, exception) -> {
            if (exception != null) {
                e.fail((Throwable)exception);
            } else {
                e.complete(null);
            }
        })).runSubscriptionOn((Executor)this.kafkaWorker);
    }

    public Map<String, ?> configuration() {
        return this.kafkaConfiguration;
    }

    public void close() {
        int timeout = this.configuration.config().getOptionalValue("default.api.timeout.ms", Integer.class).orElse(1000);
        if (this.closed.compareAndSet(false, true)) {
            Uni uni = this.runOnPollingThread((Consumer<K, V> c) -> {
                if (System.getSecurityManager() == null) {
                    c.close(Duration.ofMillis(timeout));
                } else {
                    AccessController.doPrivileged(() -> {
                        c.close(Duration.ofMillis(timeout));
                        return null;
                    });
                }
            }).onItem().invoke(this.kafkaWorker::shutdown);
            this.consumer.wakeup();
            if (Context.isOnEventLoopThread()) {
                uni.subscribeAsCompletionStage();
            } else {
                uni.await().atMost(Duration.ofMillis((long)timeout * 2L));
            }
        }
    }

    public void injectClient(MockConsumer<?, ?> consumer) {
        Consumer<K, V> cons = this.consumer;
        this.consumer = consumer;
        cons.close();
    }

    @Override
    @CheckReturnValue
    public Uni<Map<TopicPartition, Long>> getPositions() {
        return this.runOnPollingThread((Function)c -> {
            HashMap map = new HashMap();
            c.assignment().forEach(tp -> map.put(tp, c.position(tp)));
            return map;
        });
    }

    @Override
    @CheckReturnValue
    public Uni<Set<TopicPartition>> getAssignments() {
        return this.runOnPollingThread((Function)Consumer::assignment);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> seek(TopicPartition partition, long offset) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.seek(partition, offset));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.seek(partition, offsetAndMetadata));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> seekToBeginning(Collection<TopicPartition> partitions) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.seekToBeginning(partitions));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> seekToEnd(Collection<TopicPartition> partitions) {
        return this.runOnPollingThread((Consumer<K, V> c) -> c.seekToEnd(partitions));
    }

    boolean isClosed() {
        return this.closed.get();
    }

    boolean isPaused() {
        return this.paused.get();
    }

    void removeFromQueueRecordsFromTopicPartitions(Collection<TopicPartition> revokedPartitions) {
        this.stream.removeFromQueueRecordsFromTopicPartitions(revokedPartitions);
        this.batchStream.removeFromQueueRecordsFromTopicPartitions(revokedPartitions);
    }
}

