/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.tracing;

import org.apache.kafka.common.header.Headers;

public class KafkaTrace {
    private final String groupId;
    private final String clientId;
    private final int partition;
    private final String topic;
    private final long offset;
    private final Headers headers;

    private KafkaTrace(String groupId, String clientId, int partition, String topic, long offset, Headers headers) {
        this.groupId = groupId;
        this.clientId = clientId;
        this.partition = partition;
        this.topic = topic;
        this.offset = offset;
        this.headers = headers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getPartition() {
        return this.partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public long getOffset() {
        return this.offset;
    }

    public static class Builder {
        private String groupId;
        private String clientId;
        private int partition;
        private String topic;
        private long offset;
        private Headers headers;

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withPartition(int partition) {
            this.partition = partition;
            return this;
        }

        public Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder withOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withHeaders(Headers headers) {
            this.headers = headers;
            return this;
        }

        public KafkaTrace build() {
            return new KafkaTrace(this.groupId, this.clientId, this.partition, this.topic, this.offset, this.headers);
        }
    }
}

