/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class DeserializerWrapper<T>
implements Deserializer<T> {
    public static final String DESERIALIZATION_FAILURE_REASON = "deserialization-failure-reason";
    public static final String DESERIALIZATION_FAILURE_CAUSE = "deserialization-failure-cause";
    public static final String DESERIALIZATION_FAILURE_IS_KEY = "deserialization-failure-key";
    public static final String DESERIALIZATION_FAILURE_TOPIC = "deserialization-failure-topic";
    public static final String DESERIALIZATION_FAILURE_DATA = "deserialization-failure-data";
    public static final String DESERIALIZATION_FAILURE_DESERIALIZER = "deserialization-failure-deserializer";
    private static final byte[] TRUE_VALUE = "true".getBytes(StandardCharsets.UTF_8);
    private final Deserializer<T> delegate;
    private final boolean handleKeys;
    private final DeserializationFailureHandler<?> deserializationFailureHandler;
    private final KafkaSource<?, ?> source;

    public DeserializerWrapper(String className, boolean key, DeserializationFailureHandler<?> failureHandler, KafkaSource<?, ?> source) {
        this.delegate = this.createDelegateDeserializer(className);
        this.handleKeys = key;
        this.deserializationFailureHandler = failureHandler;
        this.source = source;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            this.delegate.configure(configs, isKey);
        }
        catch (Exception e) {
            this.source.reportFailure(e, true);
            throw new KafkaException((Throwable)e);
        }
    }

    private Deserializer<T> createDelegateDeserializer(String clazz) {
        try {
            return (Deserializer)Utils.newInstance((String)clazz, Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw KafkaExceptions.ex.unableToCreateInstance(clazz, e);
        }
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            return this.tryToRecover(topic, null, data, e);
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            return this.tryToRecover(topic, this.addFailureDetailsToHeaders(topic, headers, data, e), data, e);
        }
    }

    private T tryToRecover(String topic, Headers headers, byte[] data, Exception exception) {
        if (this.deserializationFailureHandler != null) {
            try {
                return (T)this.deserializationFailureHandler.handleDeserializationFailure(topic, this.handleKeys, this.delegate.getClass().getName(), data, exception, headers);
            }
            catch (Exception e) {
                KafkaLogging.log.deserializationFailureHandlerFailure(this.deserializationFailureHandler.toString(), e);
                this.source.reportFailure(e, true);
            }
        }
        return null;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private Headers addFailureDetailsToHeaders(String topic, Headers headers, byte[] data, Exception e) {
        String message = e.getMessage();
        String cause = e.getCause() != null ? e.getCause().getMessage() : null;
        headers.add(DESERIALIZATION_FAILURE_DESERIALIZER, this.delegate.getClass().getName().getBytes(StandardCharsets.UTF_8));
        headers.add(DESERIALIZATION_FAILURE_TOPIC, topic.getBytes(StandardCharsets.UTF_8));
        if (this.handleKeys) {
            headers.add(DESERIALIZATION_FAILURE_IS_KEY, TRUE_VALUE);
        }
        if (message != null) {
            headers.add(DESERIALIZATION_FAILURE_REASON, message.getBytes(StandardCharsets.UTF_8));
        }
        if (cause != null) {
            headers.add(DESERIALIZATION_FAILURE_CAUSE, cause.getBytes(StandardCharsets.UTF_8));
        }
        if (data != null) {
            headers.add(DESERIALIZATION_FAILURE_DATA, data);
        }
        return headers;
    }
}

