/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.vertx.core.Context;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.reactivestreams.Subscription;

public class KafkaRecordStream<K, V>
extends AbstractMulti<ConsumerRecord<K, V>> {
    private final ReactiveKafkaConsumer<K, V> client;
    private final KafkaConnectorIncomingConfiguration config;
    private final Context context;

    public KafkaRecordStream(ReactiveKafkaConsumer<K, V> client, KafkaConnectorIncomingConfiguration config, Context context) {
        this.config = config;
        this.client = client;
        this.context = context;
    }

    public void subscribe(MultiSubscriber<? super ConsumerRecord<K, V>> subscriber) {
        KafkaRecordStreamSubscription subscription = new KafkaRecordStreamSubscription(this.client, this.config, subscriber);
        subscriber.onSubscribe((Subscription)subscription);
    }

    private class KafkaRecordStreamSubscription
    implements Subscription {
        private final ReactiveKafkaConsumer<K, V> client;
        private final MultiSubscriber<? super ConsumerRecord<K, V>> downstream;
        private final boolean pauseResumeEnabled;
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicLong requested = new AtomicLong();
        private final AtomicBoolean started = new AtomicBoolean();
        private final AtomicBoolean paused = new AtomicBoolean();
        private final Uni<ConsumerRecords<K, V>> pollUni;
        private final Queue<ConsumerRecord<K, V>> queue;
        private final long retries;
        private volatile boolean cancelled;

        public KafkaRecordStreamSubscription(ReactiveKafkaConsumer<K, V> client, KafkaConnectorIncomingConfiguration config, MultiSubscriber<? super ConsumerRecord<K, V>> subscriber) {
            this.client = client;
            this.pauseResumeEnabled = config.getPauseIfNoRequests();
            this.downstream = subscriber;
            this.queue = new ConcurrentLinkedDeque();
            this.retries = config.getRetryAttempts() == -1 ? Long.MAX_VALUE : (long)config.getRetryAttempts().intValue();
            this.pollUni = client.poll().onItem().transform(cr -> {
                if (cr.isEmpty()) {
                    return null;
                }
                cr.forEach(this.queue::offer);
                return cr;
            }).plug(m -> {
                if (config.getRetry().booleanValue()) {
                    int maxWait = config.getRetryMaxWait();
                    return m.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost(this.retries);
                }
                return m;
            });
        }

        public void request(long n) {
            if (n > 0L) {
                if (!this.cancelled) {
                    Subscriptions.add((AtomicLong)this.requested, (long)n);
                    if (this.started.compareAndSet(false, true) && !this.cancelled) {
                        this.poll();
                    } else if (!this.cancelled) {
                        this.dispatch();
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid request");
            }
        }

        private void poll() {
            if (this.cancelled || this.client.isClosed()) {
                return;
            }
            this.pollUni.subscribe().with(cr -> {
                if (cr == null) {
                    this.client.executeWithDelay(this::poll, Duration.ofMillis(2L)).subscribe().with(x -> {}, this::report);
                } else {
                    this.dispatch();
                    this.client.runOnPollingThread(c -> this.poll()).subscribe().with(x -> {}, this::report);
                }
            }, this::report);
        }

        private void report(Throwable fail) {
            if (!this.cancelled) {
                this.cancelled = true;
                this.downstream.onFailure(fail);
            }
        }

        void dispatch() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            KafkaRecordStream.this.context.runOnContext(ignored -> this.run());
        }

        private void run() {
            int missed = 1;
            Queue q = this.queue;
            long emitted = 0L;
            long requests = this.requested.get();
            while (true) {
                int w;
                ConsumerRecord item;
                if (this.isCancelled()) {
                    return;
                }
                while (emitted != requests && (item = q.poll()) != null && !this.isCancelled()) {
                    this.downstream.onItem(item);
                    ++emitted;
                }
                requests = this.requested.addAndGet(-emitted);
                emitted = 0L;
                if (this.pauseResumeEnabled) {
                    if (requests <= (long)this.queue.size() && this.paused.compareAndSet(false, true)) {
                        KafkaLogging.log.pausingChannel(KafkaRecordStream.this.config.getChannel());
                        this.client.pause().subscribe().with(x -> {}, this::report);
                    } else if (requests > (long)this.queue.size() && this.paused.compareAndSet(true, false)) {
                        KafkaLogging.log.resumingChannel(KafkaRecordStream.this.config.getChannel());
                        this.client.resume().subscribe().with(x -> {}, this::report);
                    }
                }
                if (missed == (w = this.wip.get())) {
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            if (this.wip.getAndIncrement() == 0) {
                this.client.close();
                this.queue.clear();
            }
        }

        boolean isCancelled() {
            if (this.cancelled) {
                this.queue.clear();
                this.client.close();
                return true;
            }
            return false;
        }
    }
}

