/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.transactions;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.TechPreview;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.EmitterType;
import io.smallrye.reactive.messaging.kafka.transactions.TransactionalEmitter;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

@TechPreview(value="Tech Preview API")
public interface KafkaTransactions<T>
extends EmitterType {
    @CheckReturnValue
    public <R> Uni<R> withTransaction(Function<TransactionalEmitter<T>, Uni<R>> var1);

    @CheckReturnValue
    public <R> Uni<R> withTransaction(Message<?> var1, Function<TransactionalEmitter<T>, Uni<R>> var2);

    @CheckReturnValue
    default public Uni<Void> withTransactionAndAck(Message<?> batchMessage, Function<TransactionalEmitter<T>, Uni<Void>> work) {
        return this.withTransaction(batchMessage, work).onFailure().recoverWithUni(throwable -> Uni.createFrom().completionStage(batchMessage.nack(throwable))).onItem().transformToUni(unused -> Uni.createFrom().completionStage(batchMessage.ack()));
    }

    public boolean isTransactionInProgress();
}

