/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.tracing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaAttributesExtractor;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTrace;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTraceTextMapGetter;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import org.eclipse.microprofile.reactive.messaging.Message;

public class KafkaOpenTelemetryInstrumenter {
    private final Instrumenter<KafkaTrace, Void> instrumenter;

    private KafkaOpenTelemetryInstrumenter(Instrumenter<KafkaTrace, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static KafkaOpenTelemetryInstrumenter createForSource() {
        return KafkaOpenTelemetryInstrumenter.create(true);
    }

    public static KafkaOpenTelemetryInstrumenter createForSink() {
        return KafkaOpenTelemetryInstrumenter.create(false);
    }

    private static KafkaOpenTelemetryInstrumenter create(boolean source) {
        MessageOperation messageOperation = source ? MessageOperation.RECEIVE : MessageOperation.SEND;
        KafkaAttributesExtractor kafkaAttributesExtractor = new KafkaAttributesExtractor();
        MessagingAttributesGetter<KafkaTrace, Void> messagingAttributesGetter = kafkaAttributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation)).addAttributesExtractor((AttributesExtractor)kafkaAttributesExtractor);
        Instrumenter instrumenter = source ? builder.buildConsumerInstrumenter((TextMapGetter)KafkaTraceTextMapGetter.INSTANCE) : builder.buildProducerInstrumenter((TextMapSetter)KafkaTraceTextMapSetter.INSTANCE);
        return new KafkaOpenTelemetryInstrumenter((Instrumenter<KafkaTrace, Void>)instrumenter);
    }

    public Message<?> traceIncoming(Message<?> kafkaRecord, KafkaTrace kafkaTrace, boolean makeCurrent) {
        return TracingUtils.traceIncoming(this.instrumenter, kafkaRecord, (Object)kafkaTrace, (boolean)makeCurrent);
    }

    public void traceOutgoing(Message<?> message, KafkaTrace kafkaTrace) {
        TracingUtils.traceOutgoing(this.instrumenter, message, (Object)kafkaTrace);
    }
}

