/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.reactive.messaging.mqtt.MqttSink;
import io.smallrye.reactive.messaging.mqtt.MqttSource;
import io.vertx.reactivex.core.Vertx;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@ApplicationScoped
@Connector(value="smallrye-mqtt")
public class MqttConnector
implements IncomingConnectorFactory,
OutgoingConnectorFactory {
    static final String CONNECTOR_NAME = "smallrye-mqtt";
    @Inject
    private Instance<Vertx> instanceOfVertx;
    private boolean internalVertxInstance = false;
    private Vertx vertx;

    public void terminate(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.internalVertxInstance) {
            this.vertx.close();
        }
    }

    @PostConstruct
    void init() {
        if (this.instanceOfVertx.isUnsatisfied()) {
            this.internalVertxInstance = true;
            this.vertx = Vertx.vertx();
        } else {
            this.vertx = (Vertx)this.instanceOfVertx.get();
        }
    }

    public PublisherBuilder<? extends Message> getPublisherBuilder(Config config) {
        return new MqttSource(this.vertx, config).getSource();
    }

    public SubscriberBuilder<? extends Message, Void> getSubscriberBuilder(Config config) {
        return new MqttSink(this.vertx, config).getSink();
    }
}

