/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.reactive.messaging.mqtt.MqttConnectorCommonConfiguration;
import io.vertx.mqtt.MqttClientOptions;
import java.util.concurrent.TimeUnit;

public class MqttHelpers {
    private MqttHelpers() {
    }

    static MqttClientOptions createMqttClientOptions(MqttConnectorCommonConfiguration config) {
        MqttClientOptions options = new MqttClientOptions();
        options.setClientId((String)config.getClientId().orElse(null));
        options.setAutoGeneratedClientId(config.getAutoGeneratedClientId().booleanValue());
        options.setAutoKeepAlive(config.getAutoKeepAlive().booleanValue());
        options.setSsl(config.getSsl().booleanValue());
        options.setWillQoS(config.getWillQos().intValue());
        options.setWillFlag(config.getWillFlag().booleanValue());
        options.setWillRetain(config.getWillRetain().booleanValue());
        options.setKeepAliveTimeSeconds(config.getKeepAliveSeconds().intValue());
        options.setMaxInflightQueue(config.getMaxInflightQueue().intValue());
        options.setCleanSession(config.getAutoCleanSession().booleanValue());
        options.setMaxInflightQueue(config.getMaxInflightQueue().intValue());
        options.setReconnectAttempts(config.getReconnectAttempts().intValue());
        options.setReconnectInterval(TimeUnit.SECONDS.toMillis(config.getReconnectIntervalSeconds().intValue()));
        options.setUsername((String)config.getUsername().orElse(null));
        options.setPassword((String)config.getPassword().orElse(null));
        options.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(config.getConnectTimeoutSeconds().intValue()));
        options.setTrustAll(config.getTrustAll().booleanValue());
        return options;
    }
}

