/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.mqtt.Clients;
import io.smallrye.reactive.messaging.mqtt.MqttConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.mqtt.MqttFailStop;
import io.smallrye.reactive.messaging.mqtt.MqttFailureHandler;
import io.smallrye.reactive.messaging.mqtt.MqttHelpers;
import io.smallrye.reactive.messaging.mqtt.MqttIgnoreFailure;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import io.smallrye.reactive.messaging.mqtt.ReceivingMqttMessage;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttExceptions;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttLogging;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class MqttSource {
    private final PublisherBuilder<MqttMessage<?>> source;
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final Pattern pattern;

    public MqttSource(Vertx vertx, MqttConnectorIncomingConfiguration config) {
        MqttClientOptions options = MqttHelpers.createMqttClientOptions(config);
        String host = config.getHost();
        int def = options.isSsl() ? 8883 : 1883;
        int port = config.getPort().orElse(def);
        String server = config.getServerName().orElse(null);
        String topic = config.getTopic().orElseGet(config::getChannel);
        int qos = config.getQos();
        boolean broadcast = config.getBroadcast();
        MqttFailureHandler.Strategy strategy = MqttFailureHandler.Strategy.from(config.getFailureStrategy());
        MqttFailureHandler onNack = this.createFailureHandler(strategy, config.getChannel());
        if (topic.contains("#") || topic.contains("+")) {
            String replace = topic.replace("+", "[^/]+").replace("#", ".+");
            this.pattern = Pattern.compile(replace);
        } else {
            this.pattern = null;
        }
        Clients.ClientHolder holder = Clients.getHolder(vertx, host, port, server, options);
        this.source = ReactiveStreams.fromPublisher((Publisher)((Multi)holder.connect().onItem().produceMulti(client -> client.subscribe(topic, qos).onItem().produceMulti(x -> {
            this.subscribed.set(true);
            return holder.stream().transform().byFilteringItemsWith(m -> this.matches(topic, (MqttPublishMessage)m)).onItem().apply(m -> new ReceivingMqttMessage((MqttPublishMessage)m, onNack));
        })).then(multi -> {
            if (broadcast) {
                return multi.broadcast().toAllSubscribers();
            }
            return multi;
        })).on().cancellation(() -> this.subscribed.set(false)).onFailure().invoke(t -> MqttLogging.log.unableToConnectToBroker((Throwable)t)));
    }

    private boolean matches(String topic, MqttPublishMessage m) {
        if (this.pattern != null) {
            return this.pattern.matcher(m.topicName()).matches();
        }
        return m.topicName().equals(topic);
    }

    private MqttFailureHandler createFailureHandler(MqttFailureHandler.Strategy strategy, String channel) {
        switch (strategy) {
            case IGNORE: {
                return new MqttIgnoreFailure(channel);
            }
            case FAIL: {
                return new MqttFailStop(channel);
            }
        }
        throw MqttExceptions.ex.illegalArgumentUnknownStrategy(strategy.toString());
    }

    PublisherBuilder<MqttMessage<?>> getSource() {
        return this.source;
    }

    boolean isSubscribed() {
        return this.subscribed.get();
    }
}

