/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class MqttConnectorCommonConfiguration {
    protected final Config config;

    public MqttConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getClientId() {
        return this.config.getOptionalValue("client-id", String.class);
    }

    public Boolean getAutoGeneratedClientId() {
        return this.config.getOptionalValue("auto-generated-client-id", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getAutoKeepAlive() {
        return this.config.getOptionalValue("auto-keep-alive", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getSsl() {
        return this.config.getOptionalValue("ssl", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Integer getKeepAliveSeconds() {
        return this.config.getOptionalValue("keep-alive-seconds", Integer.class).orElse(Integer.valueOf("30"));
    }

    public Integer getMaxInflightQueue() {
        return this.config.getOptionalValue("max-inflight-queue", Integer.class).orElse(Integer.valueOf("10"));
    }

    public Boolean getAutoCleanSession() {
        return this.config.getOptionalValue("auto-clean-session", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getWillFlag() {
        return this.config.getOptionalValue("will-flag", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getWillRetain() {
        return this.config.getOptionalValue("will-retain", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Integer getWillQos() {
        return this.config.getOptionalValue("will-qos", Integer.class).orElse(Integer.valueOf("0"));
    }

    public Integer getMaxMessageSize() {
        return this.config.getOptionalValue("max-message-size", Integer.class).orElse(Integer.valueOf("8092"));
    }

    public Integer getReconnectAttempts() {
        return this.config.getOptionalValue("reconnect-attempts", Integer.class).orElse(Integer.valueOf("5"));
    }

    public Integer getReconnectIntervalSeconds() {
        return this.config.getOptionalValue("reconnect-interval-seconds", Integer.class).orElse(Integer.valueOf("1"));
    }

    public Optional<String> getUsername() {
        return this.config.getOptionalValue("username", String.class);
    }

    public Optional<String> getPassword() {
        return this.config.getOptionalValue("password", String.class);
    }

    public Integer getConnectTimeoutSeconds() {
        return this.config.getOptionalValue("connect-timeout-seconds", Integer.class).orElse(Integer.valueOf("60"));
    }

    public Boolean getTrustAll() {
        return this.config.getOptionalValue("trust-all", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getHost() {
        return (String)this.config.getOptionalValue("host", String.class).orElseThrow(() -> new IllegalArgumentException("The attribute `host` on connector 'smallrye-mqtt' (channel: " + this.getChannel() + ") must be set"));
    }

    public Optional<Integer> getPort() {
        return this.config.getOptionalValue("port", Integer.class);
    }

    public Optional<String> getServerName() {
        return this.config.getOptionalValue("server-name", String.class);
    }

    public Optional<String> getTopic() {
        return this.config.getOptionalValue("topic", String.class);
    }

    public Integer getQos() {
        return this.config.getOptionalValue("qos", Integer.class).orElse(Integer.valueOf("0"));
    }

    public void validate() {
        this.getHost();
    }
}

