/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.SendingMqttMessage;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;

public interface MqttMessage<T>
extends Message<T> {
    public static <T> MqttMessage<T> of(T payload) {
        return new SendingMqttMessage<T>(null, payload, null, false, null);
    }

    public static <T> MqttMessage<T> of(String topic, T payload) {
        return new SendingMqttMessage<T>(topic, payload, null, false, null);
    }

    public static <T> MqttMessage<T> of(String topic, T payload, Supplier<CompletionStage<Void>> ack) {
        return new SendingMqttMessage<T>(topic, payload, null, false, ack);
    }

    public static <T> MqttMessage<T> of(String topic, T payload, MqttQoS qos) {
        return new SendingMqttMessage<T>(topic, payload, qos, false);
    }

    public static <T> MqttMessage<T> of(String topic, T payload, MqttQoS qos, boolean retain) {
        return new SendingMqttMessage<T>(topic, payload, qos, retain);
    }

    default public MqttMessage<T> withAck(Supplier<CompletionStage<Void>> ack) {
        return new SendingMqttMessage<Object>(this.getTopic(), this.getPayload(), this.getQosLevel(), this.isRetain(), ack);
    }

    public int getMessageId();

    public MqttQoS getQosLevel();

    public boolean isDuplicate();

    public boolean isRetain();

    public String getTopic();
}

