/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.reactive.messaging.mqtt.MqttConnectorCommonConfiguration;
import io.vertx.mqtt.MqttClientOptions;
import java.util.concurrent.TimeUnit;

public class MqttHelpers {
    private MqttHelpers() {
    }

    static MqttClientOptions createMqttClientOptions(MqttConnectorCommonConfiguration config) {
        MqttClientOptions options = new MqttClientOptions();
        options.setCleanSession(config.getAutoCleanSession().booleanValue());
        options.setAutoGeneratedClientId(config.getAutoGeneratedClientId().booleanValue());
        options.setAutoKeepAlive(config.getAutoKeepAlive().booleanValue());
        options.setClientId((String)config.getClientId().orElse(null));
        options.setConnectTimeout(config.getConnectTimeoutSeconds().intValue());
        options.setKeepAliveInterval(config.getKeepAliveSeconds().intValue());
        options.setMaxInflightQueue(config.getMaxInflightQueue().intValue());
        options.setMaxMessageSize(config.getMaxMessageSize().intValue());
        options.setPassword((String)config.getPassword().orElse(null));
        options.setReconnectAttempts(config.getReconnectAttempts().intValue());
        options.setReconnectInterval(TimeUnit.SECONDS.toMillis(config.getReconnectIntervalSeconds().intValue()));
        options.setSsl(config.getSsl().booleanValue());
        options.setTrustAll(config.getTrustAll().booleanValue());
        options.setUsername((String)config.getUsername().orElse(null));
        options.setWillQoS(config.getWillQos().intValue());
        options.setWillFlag(config.getWillFlag().booleanValue());
        options.setWillRetain(config.getWillRetain().booleanValue());
        return options;
    }
}

