/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.reactive.messaging.mqtt.MqttConnectorCommonConfiguration;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mqtt.MqttClientOptions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MqttHelpers {
    private MqttHelpers() {
    }

    static MqttClientOptions createMqttClientOptions(MqttConnectorCommonConfiguration config) {
        MqttClientOptions options = new MqttClientOptions();
        options.setCleanSession(config.getAutoCleanSession().booleanValue());
        options.setAutoGeneratedClientId(config.getAutoGeneratedClientId().booleanValue());
        options.setAutoKeepAlive(config.getAutoKeepAlive().booleanValue());
        options.setClientId((String)config.getClientId().orElse(null));
        options.setConnectTimeout(config.getConnectTimeoutSeconds().intValue());
        options.setKeepAliveInterval(config.getKeepAliveSeconds().intValue());
        options.setMaxInflightQueue(config.getMaxInflightQueue().intValue());
        options.setMaxMessageSize(config.getMaxMessageSize().intValue());
        options.setPassword((String)config.getPassword().orElse(null));
        options.setReconnectAttempts(config.getReconnectAttempts().intValue());
        options.setReconnectInterval(TimeUnit.SECONDS.toMillis(config.getReconnectIntervalSeconds().intValue()));
        options.setSsl(config.getSsl().booleanValue());
        options.setKeyCertOptions(MqttHelpers.getKeyCertOptions(config));
        options.setTrustOptions(MqttHelpers.getTrustOptions(config));
        options.setTrustAll(config.getTrustAll().booleanValue());
        options.setUsername((String)config.getUsername().orElse(null));
        options.setWillQoS(config.getWillQos().intValue());
        options.setWillFlag(config.getWillFlag().booleanValue());
        options.setWillRetain(config.getWillRetain().booleanValue());
        return options;
    }

    private static KeyCertOptions getKeyCertOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslKeystoreLocation = config.getSslKeystoreLocation();
        Optional<String> sslKeystorePassword = config.getSslKeystorePassword();
        if (config.getSsl().booleanValue() && sslKeystoreLocation.isPresent()) {
            String keyStoreLocation = sslKeystoreLocation.get();
            String sslKeystoreType = config.getSslKeystoreType();
            if (sslKeystorePassword.isPresent()) {
                String keyStorePassword = sslKeystorePassword.get();
                if ("jks".equalsIgnoreCase(sslKeystoreType)) {
                    return new JksOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
                }
                if ("pem".equalsIgnoreCase(sslKeystoreType)) {
                    return new PemKeyCertOptions().setCertPath(keyStoreLocation).setKeyPath(keyStorePassword);
                }
                return new PfxOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + sslKeystoreType);
        }
        return null;
    }

    private static TrustOptions getTrustOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslTruststoreLocation = config.getSslTruststoreLocation();
        Optional<String> sslTruststorePassword = config.getSslTruststorePassword();
        if (config.getSsl().booleanValue() && sslTruststoreLocation.isPresent()) {
            String truststoreLocation = sslTruststoreLocation.get();
            String truststoreType = config.getSslTruststoreType();
            if ("pem".equalsIgnoreCase(truststoreType)) {
                return new PemTrustOptions().addCertPath(truststoreLocation);
            }
            if (sslTruststorePassword.isPresent()) {
                String truststorePassword = sslTruststorePassword.get();
                if ("jks".equalsIgnoreCase(truststoreType)) {
                    return new JksOptions().setPath(truststoreLocation).setPassword(truststorePassword);
                }
                return new PfxOptions().setPath(truststoreLocation).setPassword(truststorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + truststoreType);
        }
        return null;
    }
}

