/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.MqttFailureHandler;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class ReceivingMqttMessage
implements MqttMessage<byte[]> {
    final MqttPublishMessage message;
    final MqttFailureHandler onNack;

    ReceivingMqttMessage(MqttPublishMessage message, MqttFailureHandler onNack) {
        this.message = message;
        this.onNack = onNack;
    }

    public byte[] getPayload() {
        return this.message.payload().getDelegate().getBytes();
    }

    @Override
    public int getMessageId() {
        return this.message.messageId();
    }

    @Override
    public MqttQoS getQosLevel() {
        return this.message.qosLevel();
    }

    @Override
    public boolean isDuplicate() {
        return this.message.isDup();
    }

    @Override
    public boolean isRetain() {
        return this.message.isRetain();
    }

    @Override
    public String getTopic() {
        return this.message.topicName();
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(reason);
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((ReceivingMqttMessage)this).nack(arg_0);
    }
}

