/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public final class SendingMqttMessage<T>
implements MqttMessage<T> {
    private final String topic;
    private final T payload;
    private final MqttQoS qos;
    private final boolean isRetain;
    private final Supplier<CompletionStage<Void>> ack;

    SendingMqttMessage(String topic, T payload, MqttQoS qos, boolean isRetain, Supplier<CompletionStage<Void>> ack) {
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.isRetain = isRetain;
        this.ack = ack;
    }

    SendingMqttMessage(String topic, T payload, MqttQoS qos, boolean isRetain) {
        this(topic, payload, qos, isRetain, null);
    }

    public CompletionStage<Void> ack() {
        if (this.ack != null) {
            return this.ack.get();
        }
        return CompletableFuture.completedFuture(null);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public int getMessageId() {
        return -1;
    }

    @Override
    public MqttQoS getQosLevel() {
        return this.qos;
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public boolean isRetain() {
        return this.isRetain;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }
}

