/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.reactive.messaging.mqtt.MqttConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.mqtt.session.ConstantReconnectDelayOptions;
import io.smallrye.reactive.messaging.mqtt.session.MqttClientSessionOptions;
import io.smallrye.reactive.messaging.mqtt.session.ReconnectDelayOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.time.Duration;
import java.util.Optional;

public class MqttHelpers {
    private MqttHelpers() {
    }

    static MqttClientSessionOptions createMqttClientOptions(MqttConnectorCommonConfiguration config) {
        MqttClientSessionOptions options = new MqttClientSessionOptions();
        options.setCleanSession(config.getAutoCleanSession());
        options.setAutoGeneratedClientId(config.getAutoGeneratedClientId());
        options.setAutoKeepAlive(config.getAutoKeepAlive());
        options.setClientId(config.getClientId().orElse(null));
        options.setConnectTimeout(config.getConnectTimeoutSeconds() * 1000);
        options.setHostname(config.getHost());
        options.setKeepAliveInterval(config.getKeepAliveSeconds());
        options.setMaxInflightQueue(config.getMaxInflightQueue());
        options.setMaxMessageSize(config.getMaxMessageSize());
        options.setPassword(config.getPassword().orElse(null));
        options.setPort(config.getPort().orElseGet(() -> config.getSsl() != false ? 8883 : 1883));
        options.setReconnectDelay(MqttHelpers.getReconnectDelayOptions(config));
        options.setSsl(config.getSsl());
        options.setKeyCertOptions(MqttHelpers.getKeyCertOptions(config));
        options.setServerName(config.getServerName());
        options.setTrustOptions(MqttHelpers.getTrustOptions(config));
        options.setTrustAll(config.getTrustAll());
        options.setUsername(config.getUsername().orElse(null));
        options.setWillQoS(config.getWillQos());
        options.setWillFlag(config.getWillFlag());
        options.setWillRetain(config.getWillRetain());
        return options;
    }

    private static KeyCertOptions getKeyCertOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslKeystoreLocation = config.getSslKeystoreLocation();
        Optional<String> sslKeystorePassword = config.getSslKeystorePassword();
        if (config.getSsl().booleanValue() && sslKeystoreLocation.isPresent()) {
            String keyStoreLocation = sslKeystoreLocation.get();
            String sslKeystoreType = config.getSslKeystoreType();
            if (sslKeystorePassword.isPresent()) {
                String keyStorePassword = sslKeystorePassword.get();
                if ("jks".equalsIgnoreCase(sslKeystoreType)) {
                    return new JksOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
                }
                if ("pem".equalsIgnoreCase(sslKeystoreType)) {
                    return new PemKeyCertOptions().setCertPath(keyStoreLocation).setKeyPath(keyStorePassword);
                }
                return new PfxOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + sslKeystoreType);
        }
        return null;
    }

    private static TrustOptions getTrustOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslTruststoreLocation = config.getSslTruststoreLocation();
        Optional<String> sslTruststorePassword = config.getSslTruststorePassword();
        if (config.getSsl().booleanValue() && sslTruststoreLocation.isPresent()) {
            String truststoreLocation = sslTruststoreLocation.get();
            String truststoreType = config.getSslTruststoreType();
            if ("pem".equalsIgnoreCase(truststoreType)) {
                return new PemTrustOptions().addCertPath(truststoreLocation);
            }
            if (sslTruststorePassword.isPresent()) {
                String truststorePassword = sslTruststorePassword.get();
                if ("jks".equalsIgnoreCase(truststoreType)) {
                    return new JksOptions().setPath(truststoreLocation).setPassword(truststorePassword);
                }
                return new PfxOptions().setPath(truststoreLocation).setPassword(truststorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + truststoreType);
        }
        return null;
    }

    private static ReconnectDelayOptions getReconnectDelayOptions(MqttConnectorCommonConfiguration config) {
        ConstantReconnectDelayOptions options = new ConstantReconnectDelayOptions();
        options.setDelay(Duration.ofSeconds(config.getReconnectIntervalSeconds().intValue()));
        return options;
    }
}

