/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.mqtt.Clients;
import io.smallrye.reactive.messaging.mqtt.MqttConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.mqtt.MqttFailStop;
import io.smallrye.reactive.messaging.mqtt.MqttFailureHandler;
import io.smallrye.reactive.messaging.mqtt.MqttHelpers;
import io.smallrye.reactive.messaging.mqtt.MqttIgnoreFailure;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import io.smallrye.reactive.messaging.mqtt.ReceivingMqttMessage;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttExceptions;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttLogging;
import io.smallrye.reactive.messaging.mqtt.session.MqttClientSessionOptions;
import io.smallrye.reactive.messaging.mqtt.session.RequestedQoS;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class MqttSource {
    private final PublisherBuilder<MqttMessage<?>> source;
    private final AtomicBoolean ready = new AtomicBoolean();
    private final Pattern pattern;

    public MqttSource(Vertx vertx, MqttConnectorIncomingConfiguration config) {
        MqttClientSessionOptions options = MqttHelpers.createMqttClientOptions(config);
        String topic = config.getTopic().orElseGet(config::getChannel);
        int qos = config.getQos();
        boolean broadcast = config.getBroadcast();
        MqttFailureHandler.Strategy strategy = MqttFailureHandler.Strategy.from(config.getFailureStrategy());
        MqttFailureHandler onNack = this.createFailureHandler(strategy, config.getChannel());
        if (topic.contains("#") || topic.contains("+")) {
            String replace = topic.replace("+", "[^/]+").replace("#", ".+");
            this.pattern = Pattern.compile(replace);
        } else {
            this.pattern = null;
        }
        Clients.ClientHolder holder = Clients.getHolder(vertx, options);
        holder.start();
        holder.getClient().subscribe(topic, RequestedQoS.valueOf(qos)).onComplete(outcome -> MqttLogging.log.info("Subscription outcome: " + outcome)).onSuccess(ignore -> this.ready.set(true));
        this.source = ReactiveStreams.fromPublisher((Publisher)((Multi)holder.stream().select().where(m -> this.matches(topic, (MqttPublishMessage)m)).onItem().transform(m -> new ReceivingMqttMessage((MqttPublishMessage)m, onNack)).stage(multi -> {
            if (broadcast) {
                return multi.broadcast().toAllSubscribers();
            }
            return multi;
        })).onOverflow().buffer(config.getBufferSize().intValue()).onCancellation().call(() -> {
            this.ready.set(false);
            return Uni.createFrom().completionStage(holder.getClient().unsubscribe(topic).toCompletionStage());
        }).onFailure().invoke(MqttLogging.log::unableToConnectToBroker));
    }

    private boolean matches(String topic, MqttPublishMessage m) {
        if (this.pattern != null) {
            return this.pattern.matcher(m.topicName()).matches();
        }
        return m.topicName().equals(topic);
    }

    private MqttFailureHandler createFailureHandler(MqttFailureHandler.Strategy strategy, String channel) {
        switch (strategy) {
            case IGNORE: {
                return new MqttIgnoreFailure(channel);
            }
            case FAIL: {
                return new MqttFailStop(channel);
            }
        }
        throw MqttExceptions.ex.illegalArgumentUnknownStrategy(strategy.toString());
    }

    PublisherBuilder<MqttMessage<?>> getSource() {
        return this.source;
    }

    public boolean isReady() {
        return this.ready.get();
    }
}

