package io.smallrye.reactive.messaging.mqtt.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class MqttLogging_$logger extends DelegatingBasicLogger implements MqttLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MqttLogging_$logger.class.getName();
    public MqttLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void messageNackedFailStop(final String channel) {
        super.log.logf(FQCN, ERROR, null, messageNackedFailStop$str(), channel);
    }
    protected String messageNackedFailStop$str() {
        return "SRMSG17100: A message sent to channel `%s` has been nacked, fail-stop";
    }
    @Override
    public final void messageNackedIgnore(final String channel, final String reason) {
        super.log.logf(FQCN, WARN, null, messageNackedIgnore$str(), channel, reason);
    }
    protected String messageNackedIgnore$str() {
        return "SRMSG17101: A message sent to channel `%s` has been nacked, ignored failure is: %s.";
    }
    @Override
    public final void messageNackedFullIgnored(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, messageNackedFullIgnored$str());
    }
    protected String messageNackedFullIgnored$str() {
        return "SRMSG17102: The full ignored failure is";
    }
    @Override
    public final void errorWhileSendingMessageToBroker(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileSendingMessageToBroker$str());
    }
    protected String errorWhileSendingMessageToBroker$str() {
        return "SRMSG17103: An error has been caught while sending a MQTT message to the broker";
    }
    @Override
    public final void ignoringNoTopicSet() {
        super.log.logf(FQCN, ERROR, null, ignoringNoTopicSet$str());
    }
    protected String ignoringNoTopicSet$str() {
        return "SRMSG17104: Ignoring message - no topic set";
    }
    @Override
    public final void unableToConnectToBroker(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToConnectToBroker$str());
    }
    protected String unableToConnectToBroker$str() {
        return "SRMSG17105: Unable to establish a connection with the MQTT broker";
    }
}
