/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.session;

import io.smallrye.reactive.messaging.mqtt.session.ConstantReconnectDelayOptions;
import io.smallrye.reactive.messaging.mqtt.session.ReconnectDelayOptions;
import io.vertx.mqtt.MqttClientOptions;
import java.util.Optional;

public class MqttClientSessionOptions
extends MqttClientOptions {
    private static final ReconnectDelayOptions DEFAULT_RECONNECT_DELAY = new ConstantReconnectDelayOptions();
    private static final Optional<String> DEFAULT_SERVER_NAME = Optional.empty();
    private String hostname = "localhost";
    private Optional<String> serverName = DEFAULT_SERVER_NAME;
    private int port = 1883;
    private ReconnectDelayOptions reconnectDelay = DEFAULT_RECONNECT_DELAY;
    private boolean unsubscribeOnDisconnect = false;

    public MqttClientSessionOptions() {
    }

    public MqttClientSessionOptions(MqttClientSessionOptions other) {
        super((MqttClientOptions)other);
        this.hostname = other.hostname;
        this.port = other.port;
        this.serverName = other.serverName;
        this.reconnectDelay = other.reconnectDelay.copy();
    }

    public int getPort() {
        return this.port;
    }

    public MqttClientSessionOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public MqttClientSessionOptions setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MqttClientSessionOptions setReconnectDelay(ReconnectDelayOptions reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        return this;
    }

    public ReconnectDelayOptions getReconnectDelay() {
        return this.reconnectDelay;
    }

    public Optional<String> getServerName() {
        return this.serverName;
    }

    public MqttClientSessionOptions setServerName(Optional<String> serverName) {
        this.serverName = serverName;
        return this;
    }

    public boolean isUnsubscribeOnDisconnect() {
        return this.unsubscribeOnDisconnect;
    }

    public void setUnsubscribeOnDisconnect(boolean unsubscribeOnDisconnect) {
        this.unsubscribeOnDisconnect = unsubscribeOnDisconnect;
    }
}

