/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.internal;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.mqtt.MqttConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttExceptions;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttLogging;
import io.smallrye.reactive.messaging.mqtt.session.ConstantReconnectDelayOptions;
import io.smallrye.reactive.messaging.mqtt.session.MqttClientSessionOptions;
import io.smallrye.reactive.messaging.mqtt.session.ReconnectDelayOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;

public class MqttHelpers {
    private MqttHelpers() {
    }

    private static MqttClientSessionOptions createMqttClientOptions(MqttConnectorCommonConfiguration config) {
        MqttClientSessionOptions options = new MqttClientSessionOptions();
        options.setCleanSession(config.getAutoCleanSession());
        options.setAutoGeneratedClientId(config.getAutoGeneratedClientId());
        options.setAutoKeepAlive(config.getAutoKeepAlive());
        options.setClientId(config.getClientId().orElse(null));
        options.setConnectTimeout(config.getConnectTimeoutSeconds() * 1000);
        options.setHostname(config.getHost());
        options.setKeepAliveInterval(config.getKeepAliveSeconds());
        options.setMaxInflightQueue(config.getMaxInflightQueue());
        options.setMaxMessageSize(config.getMaxMessageSize());
        options.setPassword(config.getPassword().orElse(null));
        options.setPort(config.getPort().orElseGet(() -> config.getSsl() != false ? 8883 : 1883));
        options.setReconnectDelay(MqttHelpers.getReconnectDelayOptions(config));
        options.setSsl(config.getSsl());
        options.setKeyCertOptions(MqttHelpers.getKeyCertOptions(config));
        options.setServerName(config.getServerName());
        options.setTrustOptions(MqttHelpers.getTrustOptions(config));
        options.setTrustAll(config.getTrustAll());
        options.setUsername(config.getUsername().orElse(null));
        options.setWillQoS(config.getWillQos());
        options.setWillFlag(config.getWillFlag());
        options.setWillRetain(config.getWillRetain());
        options.setUnsubscribeOnDisconnect(config.getUnsubscribeOnDisconnection());
        return options;
    }

    public static MqttClientSessionOptions createClientOptions(MqttConnectorCommonConfiguration config, Instance<MqttClientSessionOptions> mqttClientOptions) {
        Optional<String> clientOptionsName = config.getClientOptionsName();
        MqttClientSessionOptions options = clientOptionsName.isPresent() ? MqttHelpers.createClientOptionsFromClientOptionsBean(mqttClientOptions, clientOptionsName.get(), config) : MqttHelpers.createMqttClientOptions(config);
        return options;
    }

    static MqttClientSessionOptions createClientOptionsFromClientOptionsBean(Instance<MqttClientSessionOptions> instance, String optionsBeanName, MqttConnectorCommonConfiguration config) {
        Instance options = instance.select(new Annotation[]{Identifier.Literal.of((String)optionsBeanName)});
        if (options.isUnsatisfied()) {
            throw MqttExceptions.ex.illegalStateFindingBean(MqttClientSessionOptions.class.getName(), optionsBeanName);
        }
        MqttLogging.log.createClientFromBean(optionsBeanName);
        MqttClientSessionOptions customizerOptions = (MqttClientSessionOptions)((Object)options.get());
        MqttHelpers.merge(customizerOptions, config);
        return customizerOptions;
    }

    static void merge(MqttClientSessionOptions custom, MqttConnectorCommonConfiguration config) {
        MqttClientSessionOptions channel = MqttHelpers.createMqttClientOptions(config);
        String hostFromChannel = channel.getHostname();
        int portFromChannel = channel.getPort();
        if (MqttHelpers.isSetInChannelConfiguration("username", config)) {
            custom.setUsername(channel.getUsername());
        }
        if (custom.getUsername() == null) {
            custom.setUsername(channel.getUsername());
        }
        if (MqttHelpers.isSetInChannelConfiguration("password", config)) {
            custom.setPassword(channel.getPassword());
        }
        if (custom.getPassword() == null) {
            custom.setPassword(channel.getPassword());
        }
        if (MqttHelpers.isSetInChannelConfiguration("host", config)) {
            custom.setHostname(hostFromChannel);
        }
        if (custom.getHostname() == null) {
            custom.setHostname(channel.getHostname());
        }
        if (MqttHelpers.isSetInChannelConfiguration("port", config)) {
            custom.setPort(portFromChannel);
        }
        if (MqttHelpers.isSetInChannelConfiguration("ssl", config)) {
            custom.setSsl(channel.isSsl());
        }
        if (MqttHelpers.isSetInChannelConfiguration("reconnect-attempts", config)) {
            custom.setReconnectAttempts(channel.getReconnectAttempts());
        }
        if (MqttHelpers.isSetInChannelConfiguration("reconnect-interval", config)) {
            custom.setReconnectInterval(channel.getReconnectInterval());
        }
        if (MqttHelpers.isSetInChannelConfiguration("connect-timeout", config)) {
            custom.setConnectTimeout(channel.getConnectTimeout());
        }
        if (MqttHelpers.isSetInChannelConfiguration("auto-clean-session", config)) {
            custom.setCleanSession(config.getAutoCleanSession());
        }
        if (MqttHelpers.isSetInChannelConfiguration("auto-generated-client-id", config)) {
            custom.setAutoGeneratedClientId(config.getAutoGeneratedClientId());
        }
        if (MqttHelpers.isSetInChannelConfiguration("auto-keep-alive", config)) {
            custom.setAutoKeepAlive(config.getAutoKeepAlive());
        }
        if (MqttHelpers.isSetInChannelConfiguration("client-id", config)) {
            custom.setClientId(config.getClientId().orElse(null));
        }
        if (MqttHelpers.isSetInChannelConfiguration("keep-alive-interval", config)) {
            custom.setKeepAliveInterval(config.getKeepAliveSeconds());
        }
        if (MqttHelpers.isSetInChannelConfiguration("max-inflight-queue", config)) {
            custom.setMaxInflightQueue(config.getMaxInflightQueue());
        }
        if (MqttHelpers.isSetInChannelConfiguration("max-message-size", config)) {
            custom.setMaxMessageSize(config.getMaxMessageSize());
        }
        if (MqttHelpers.isSetInChannelConfiguration("reconnect-interval-seconds", config)) {
            custom.setReconnectDelay(MqttHelpers.getReconnectDelayOptions(config));
        }
        if (MqttHelpers.isSetInChannelConfiguration("ssl-keystore-location", config)) {
            custom.setKeyCertOptions(MqttHelpers.getKeyCertOptions(config));
        }
        if (MqttHelpers.isSetInChannelConfiguration("server-name", config)) {
            custom.setServerName(config.getServerName());
        }
        if (MqttHelpers.isSetInChannelConfiguration("ssl-truststore-location", config)) {
            custom.setTrustOptions(MqttHelpers.getTrustOptions(config));
        }
        if (MqttHelpers.isSetInChannelConfiguration("trust-all", config)) {
            custom.setTrustAll(config.getTrustAll());
        }
        if (MqttHelpers.isSetInChannelConfiguration("will-qus", config)) {
            custom.setWillQoS(config.getWillQos());
        }
        if (MqttHelpers.isSetInChannelConfiguration("will-flag", config)) {
            custom.setWillFlag(config.getWillFlag());
        }
        if (MqttHelpers.isSetInChannelConfiguration("will-retain", config)) {
            custom.setWillRetain(config.getWillRetain());
        }
        if (MqttHelpers.isSetInChannelConfiguration("unsubscribe-on-disconnection", config)) {
            custom.setUnsubscribeOnDisconnect(config.getUnsubscribeOnDisconnection());
        }
    }

    private static KeyCertOptions getKeyCertOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslKeystoreLocation = config.getSslKeystoreLocation();
        Optional<String> sslKeystorePassword = config.getSslKeystorePassword();
        if (config.getSsl().booleanValue() && sslKeystoreLocation.isPresent()) {
            String keyStoreLocation = sslKeystoreLocation.get();
            String sslKeystoreType = config.getSslKeystoreType();
            if (sslKeystorePassword.isPresent()) {
                String keyStorePassword = sslKeystorePassword.get();
                if ("jks".equalsIgnoreCase(sslKeystoreType)) {
                    return new JksOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
                }
                if ("pem".equalsIgnoreCase(sslKeystoreType)) {
                    return new PemKeyCertOptions().setCertPath(keyStoreLocation).setKeyPath(keyStorePassword);
                }
                return new PfxOptions().setPath(keyStoreLocation).setPassword(keyStorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + sslKeystoreType);
        }
        return null;
    }

    private static TrustOptions getTrustOptions(MqttConnectorCommonConfiguration config) {
        Optional<String> sslTruststoreLocation = config.getSslTruststoreLocation();
        Optional<String> sslTruststorePassword = config.getSslTruststorePassword();
        if (config.getSsl().booleanValue() && sslTruststoreLocation.isPresent()) {
            String truststoreLocation = sslTruststoreLocation.get();
            String truststoreType = config.getSslTruststoreType();
            if ("pem".equalsIgnoreCase(truststoreType)) {
                return new PemTrustOptions().addCertPath(truststoreLocation);
            }
            if (sslTruststorePassword.isPresent()) {
                String truststorePassword = sslTruststorePassword.get();
                if ("jks".equalsIgnoreCase(truststoreType)) {
                    return new JksOptions().setPath(truststoreLocation).setPassword(truststorePassword);
                }
                return new PfxOptions().setPath(truststoreLocation).setPassword(truststorePassword);
            }
            throw new IllegalArgumentException("The attribute `ssl.keystore.password` on connector 'smallrye-mqtt' (channel: " + config.getChannel() + ") must be set for `ssl.keystore.type`" + truststoreType);
        }
        return null;
    }

    private static ReconnectDelayOptions getReconnectDelayOptions(MqttConnectorCommonConfiguration config) {
        ConstantReconnectDelayOptions options = new ConstantReconnectDelayOptions();
        options.setDelay(Duration.ofSeconds(config.getReconnectIntervalSeconds().intValue()));
        return options;
    }

    public static String rebuildMatchesWithSharedSubscription(String topic) {
        if (Pattern.matches("^\\$share/((?!/).)*/.*", topic)) {
            return topic.replaceAll("^\\$share/((?!/).)*/", "");
        }
        return topic;
    }

    static boolean isSetInChannelConfiguration(String attribute, MqttConnectorCommonConfiguration configuration) {
        return configuration.config().getConfigValue(attribute).getRawValue() != null;
    }
}

