|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *auto-clean-session* | Set to start with a clean session (`true` by default) | boolean | false | `true` |
| *auto-generated-client-id* | Set if the MQTT client must generate clientId automatically | boolean | false | `true` |
| *auto-keep-alive* | Set if the MQTT client must handle `PINGREQ` automatically | boolean | false | `true` |
| *client-id* | Set the client identifier | string | false |  |
| *client-options-name* _(mqtt-client-options-name)_ | The name of the MQTT Client Option bean (`io.smallrye.reactive.messaging.mqtt.session.MqttClientSessionOptions`) used to customize the MQTT client configuration | string | false |  |
| *connect-timeout-seconds* | Set the connect timeout (in seconds) | int | false | `60` |
| *host* | Set the MQTT server host name/IP | string | true |  |
| *keep-alive-seconds* | Set the keep alive timeout in seconds | int | false | `30` |
| *max-inflight-queue* | Set max count of unacknowledged messages | int | false | `10` |
| *max-message-size* | Set max MQTT message size in bytes | int | false | `8092` |
| *merge* | Whether the connector should allow multiple upstreams | boolean | false | `false` |
| *password* | Set the password to connect to the server | string | false |  |
| *port* | Set the MQTT server port. Default to 8883 if ssl is enabled, or 1883 without ssl | int | false |  |
| *qos* | Set the QoS level when subscribing to the topic or when sending a message | int | false | `0` |
| *reconnect-interval-seconds* | Set the reconnect interval in seconds | int | false | `1` |
| *server-name* | Set the SNI server name | string | false |  |
| *ssl* | Set whether SSL/TLS is enabled | boolean | false | `false` |
| *ssl.keystore.location* | Set the keystore location. In case of `pem` type this is the server ca cert path | string | false |  |
| *ssl.keystore.password* | Set the keystore password. In case of `pem` type this is the key path | string | false |  |
| *ssl.keystore.type* | Set the keystore type [`pkcs12`, `jks`, `pem`] | string | false | `pkcs12` |
| *ssl.truststore.location* | Set the truststore location. In case of `pem` type this is the client cert path | string | false |  |
| *ssl.truststore.password* | Set the truststore password. In case of `pem` type this is not necessary | string | false |  |
| *ssl.truststore.type* | Set the truststore type [`pkcs12`, `jks`, `pem`] | string | false | `pkcs12` |
| *topic* | Set the MQTT topic. If not set, the channel name is used | string | false |  |
| *trust-all* | Set whether all server certificates should be trusted | boolean | false | `false` |
| *unsubscribe-on-disconnection* | This flag restore the old behavior to unsubscribe from the broken on disconnection | boolean | false | `false` |
| *username* | Set the username to connect to the server | string | false |  |
| *will-flag* | Set if will information are provided on connection | boolean | false | `false` |
| *will-qos* | Set the QoS level for the will message | int | false | `0` |
| *will-retain* | Set if the will message must be retained | boolean | false | `false` |
