package io.smallrye.reactive.messaging.mqtt;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the incoming configuration for the {@code smallrye-mqtt} connector.
*/
public class MqttConnectorIncomingConfiguration extends MqttConnectorCommonConfiguration {

  /**
   * Creates a new MqttConnectorIncomingConfiguration.
   */
  public MqttConnectorIncomingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the broadcast value from the configuration.
  * Attribute Name: broadcast
  * Description: Whether or not the messages should be dispatched to multiple consumers
  * Default Value: false
  * @return the broadcast
  */
  public Boolean getBroadcast() {
    return config.getOptionalValue("broadcast", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  /**
  * Gets the failure-strategy value from the configuration.
  * Attribute Name: failure-strategy
  * Description: Specify the failure strategy to apply when a message produced from a MQTT message is nacked. Values can be `fail` (default), or `ignore`
  * Default Value: fail
  * @return the failure-strategy
  */
  public String getFailureStrategy() {
    return config.getOptionalValue("failure-strategy", String.class)
     .orElse("fail");
  }

  /**
  * Gets the buffer-size value from the configuration.
  * Attribute Name: buffer-size
  * Description: The size buffer of incoming messages waiting to be processed
  * Default Value: 128
  * @return the buffer-size
  */
  public Integer getBufferSize() {
    return config.getOptionalValue("buffer-size", Integer.class)
     .orElse(Integer.valueOf("128"));
  }

  public void validate() {
    super.validate();
  }
}
