package io.smallrye.reactive.messaging.mqtt;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the outgoing configuration for the {@code smallrye-mqtt} connector.
*/
public class MqttConnectorOutgoingConfiguration extends MqttConnectorCommonConfiguration {

  /**
   * Creates a new MqttConnectorOutgoingConfiguration.
   */
  public MqttConnectorOutgoingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the merge value from the configuration.
  * Attribute Name: merge
  * Description: Whether the connector should allow multiple upstreams
  * Default Value: false
  * @return the merge
  */
  public Boolean getMerge() {
    return config.getOptionalValue("merge", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  /**
  * Gets the retain value from the configuration.
  * Attribute Name: retain
  * Description: Whether the published message should be retained
  * Default Value: false
  * @return the retain
  */
  public Boolean getRetain() {
    return config.getOptionalValue("retain", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  public void validate() {
    super.validate();
  }
}
